﻿package 
{
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author Daniel Bienvenu
	 */
	public class SoundEngine 
	{		
		// SOUND CHIP POINTER
		private var sndchip:SoundChip;
		
		// SOUND TABLES
		private var sndtable:Array = new Array(4);
		private var sndtableindex:Array = new Array(4);
		private var nbrtables:int;
		
		// CHANNELS EFFECTS		
        private var channel:Array = new Array(4);
        private var i_initial_period:Array = new Array(4);
        private var b_initial_attenuation:Array = new Array(4);
        private var is_attenuation_swept_note:Array = new Array(4);
        private var b_attenuation_step:Array = new Array(4);
        private var i_numberof_attenuation_step:Array = new Array(4);
        private var i_attenuation_step_length:Array = new Array(4);
        private var i_first_attenuation_step_length:Array = new Array(4);
		private var is_period_swept_note:Array = new Array(4);
        private var i_numberof_period_step:Array = new Array(4);
        private var i_period_step:Array = new Array(4);
        private var i_period_step_length:Array = new Array(4);
        private var i_first_period_step_length:Array = new Array(4);
        private var b_noise_code:int;
        private var b_current_noise_code:int;
        private var i_actual_period:Array = new Array(4);
        private var b_actual_attenuation:Array = new Array(4);
        private var i_actual_period_step_length:Array = new Array(4);
        private var i_actual_attenuation_step_length:Array = new Array(4);
        private var i_length_note:Array = new Array(4);
		
		public function SoundEngine() {
			sndchip = null;
			reset();
		}
		
		public function setSoundChip(chip:SoundChip):void {
			sndchip = chip;
		}
		
		public function reset():void {
			play();
			nbrtables = 0;
		}
		
		public function play(e:Event = null):void {
			if (e != null) { 
				e.stopImmediatePropagation();
				//trace("BUTTON : REPLAY");
			} else {
				//trace("PLAY");
			}
			for (var i:int = 0; i < 4; i++) {
				i_length_note[i] = 0;
				sndtableindex[i] = 0;
				channel[i] = -1;
			}
		}
		
		public function update_sound():void {
			var ch:int;
			
			var channel_period:Array = new Array(4);
			var channel_attenuation:Array = new Array(4);
			
			for (ch = 0; ch < 4; ch++) {
				channel_period[ch] = 0;
				channel_attenuation[ch] = 15;
			}
			
			if (sndchip != null) {
				for (var i:int = 0; i < nbrtables; i++) {					
					if (i_length_note[i] == 0) {
						var old:int = sndtableindex[i];
						load_next_note(i);
						
						/* DEBUG : Trace loaded code */
						//var r:String = new String;
						//for (var ii:int = 0; ii < sndtableindex[i] - old; ii++) {
							//r += String(sndtable[i][ii + old])+",";
						//}
						//if (r.length > 0) trace(r);
					}
					
					ch = channel[i];
					if (ch != -1) {
						if (ch > 0)
						{
							channel_period[ch] = i_actual_period[i];
							channel_attenuation[ch] = b_actual_attenuation[i];
						}
						else
						{
							channel_period[ch] = b_noise_code;
							channel_attenuation[ch] = b_actual_attenuation[i];
						}
					}
					
					// UPDATE SOUND
					if (i_length_note[i] > 0)
					{
						i_length_note[i]--;
						if (i_length_note[i] != 0) {
							if (is_attenuation_swept_note[i])
							{
								if (i_actual_attenuation_step_length[i] > 1)
								{
									i_actual_attenuation_step_length[i]--;
								}
								else
								{
									if (i_numberof_attenuation_step[i] > 1)
									{
										i_numberof_attenuation_step[i]--;
										i_actual_attenuation_step_length[i] = i_attenuation_step_length[i];
										b_actual_attenuation[i] += b_attenuation_step[i];
										b_actual_attenuation[i] &= 0x0f;
									} else is_attenuation_swept_note[i] = false;   
								}
							}
							if (is_period_swept_note[i])
							{
								if (i_actual_period_step_length[i] > 1)
								{
									i_actual_period_step_length[i]--;
								}
								else
								{
									i_actual_period_step_length[i] = i_period_step_length[i];
									i_actual_period[i] += i_period_step[i];
									i_actual_period[i] &= 0x3ff;
								}
							}
						}
					} 
				}
				
				for (ch = 0; ch < 4; ch++) {
					if (ch != 0) {
						sndchip.tone(ch, channel_period[ch], channel_attenuation[ch]);
					} else {
						sndchip.noise_coleco(channel_period[ch], channel_attenuation[ch]);
					}
				}
			}
		}
		
		private function if0then16(value:int):int {
			if (value==0) return 16; else return value;
		}
		
		private function if0then256(value:int):int {
			if (value==0) return 256; else return value;
		}
		
		private function load_next_note(no:int):void {
			var code:int;
			var ch:int;
			var sndtbl:Array = sndtable[no];
			var limit:int = sndtbl.length;
			
			if (limit <= sndtableindex[no]) {
				code = 0xff;
			} else {
				code = sndtbl[sndtableindex[no]];
			}
			
			if (code != 0xff) {
				
				ch = (code >>> 6) & 3;
				code &= 0x3f;
				sndtableindex[no] += 1;
				
				if ((code & 0x20)==0x20)
				{
					/* rest (no sound for a period of time) */
					i_length_note[no] = if0then256(code & 0x1f);
					is_attenuation_swept_note[no] = false;
					is_period_swept_note[no] = false;
					b_actual_attenuation[no] = 15;
				}
				else
				{
					channel[no] = ch;
					/* note */
					switch (code)
					{
						case 0 : /* Simple Note */
							if (ch == 0) sndtableindex[no] += 1;
						case 2 : /* Volume Swept */                   
							if (ch == 0)
							{
								b_noise_code = sndtbl[sndtableindex[no]] & 7;
							}
						case 1 : /* Frequency Swept */
						case 3 : /* Volume and Frequency Swept */
							if (ch != 0)
							{
								i_initial_period[no] = (sndtbl[sndtableindex[no]+1] & 3) << 8;
								i_initial_period[no] |= (sndtbl[sndtableindex[no]] & 0xff);
								sndtableindex[no] += 1;
							}    
							b_initial_attenuation[no] = (sndtbl[sndtableindex[no]] >> 4) & 0x0f;
							sndtableindex[no] += 1;
							i_length_note[no] = if0then256(sndtbl[sndtableindex[no]] & 255);
							sndtableindex[no] += 1;
							
							if ((code & 1) == 1)
							{
								i_numberof_period_step[no] = i_length_note[no];
								i_period_step_length[no] = if0then16((sndtbl[sndtableindex[no]] >> 4) & 15);
								i_first_period_step_length[no] = if0then16(sndtbl[sndtableindex[no]] & 15);
								sndtableindex[no] += 1;
								i_period_step[no] = sndtbl[sndtableindex[no]];
								if (i_period_step[no] >= 128) i_period_step[no] -= 256;
								sndtableindex[no] += 1;
								if (i_period_step[no]!=0)
								{
									i_length_note[no] = i_first_period_step_length[no] + i_period_step_length[no] * (i_numberof_period_step[no] - 1);
									i_actual_period_step_length[no] = i_first_period_step_length[no];
									is_period_swept_note[no] = true;
								}    
								else
								{
									is_period_swept_note[no] = false;
								}    
								
							}
							else
							{
								is_period_swept_note[no] = false;
							}
							
							if ((code & 2) == 2)
							{
								b_attenuation_step[no] = (sndtbl[sndtableindex[no]] >> 4) & 15;
								i_numberof_attenuation_step[no] = if0then16(sndtbl[sndtableindex[no]] & 15);
								sndtableindex[no] += 1;
								i_attenuation_step_length[no] = if0then16((sndtbl[sndtableindex[no]] >>> 4) & 15);
								i_first_attenuation_step_length[no] = if0then16(sndtbl[sndtableindex[no]] & 15);
								sndtableindex[no] += 1;
								i_actual_attenuation_step_length[no] = i_first_attenuation_step_length[no];
								is_attenuation_swept_note[no] = true;
							}
							else is_attenuation_swept_note[no] = false;
							
							i_actual_period[no] = i_initial_period[no];
							b_actual_attenuation[no] = b_initial_attenuation[no];
							
							break;
							
						case 0x18 :
							/* Repeat */
							sndtableindex[no] = 0;
							load_next_note(no);
							break;
						case 4 :
							/* Software FX - not supported - */
						case 0x10 :
							/* END */
							//sndtableindex[no] -= 1;
						default :
							/* Wrong Sound Code */
							//b_endofsoundtable[no] = true;					
							b_actual_attenuation[no] = 15;
							break;
					}
					
				}
				
			} else {
				// ADDED
				b_actual_attenuation[no] = 15;
			}
			
		}
		
		public function setTables(tables:SoundTables):void {
			var i:int;			
			reset();
			nbrtables = tables.nbrtables;			
			for (i = 0; i < nbrtables; i++) {
				sndtable[i] = tables.table[i];
			}			
		}
		
		public function demoSelection(e:MouseEvent = null):void {
			e.stopImmediatePropagation();
			switch (e.currentTarget.text) {
				case "Donkey Kong" :
					demo(0);
					break;
				case "Victory Pause" :
					demo(1);
					break;
				case "Rocky" :
					demo(2);
					break;
				case "Space Fury" :
					demo(3);
					break;
				case "Boulder Dash" :
					demo(4);
					break;
				case "Venture Bonus FX" :
					demo(5);
					break;
				case "Time Pilot" :
					demo(6);
					break;
				case "Time Pilot Pause" :
					demo(7);
					break;
				case "Slither Pause" :
					demo(8);
					break;
				case "Noise Test" :
					demo(9);
					break;
				case "Space Hunter" :
					demo(10);
					break;
				case "BlackJack Poker" :
					demo(11);
					break;
				case "BlackJack Poker Wait" :
					demo(12);
					break;
				case "Burger Time" :
					demo(13);
					break;
				case "Omega Race" :
					demo(14);
					break;
				case "Pepper II" :
					demo(15);
					break;
				case "Spy Hunter" :
					demo(16);
					break;
				default:
					reset();
					break;
			}
		}
		
		public function demo(choice:int = 0):void {
			
			reset();
			
			switch(choice) {
				
				case 0:
				
					// DONKEY KONG LEVEL INTRO
					sndtable[0] = [
						0xc2,0xd6,0x00,0x12,0x1c,0x22, // tone freq 522,7Hz - vol 15 (max) swept down - length 18
						0xc2,0xbe,0x00,0x12,0x1c,0x22, // tone freq 588,7Hz - vol 15 (max) swept down - length 18
						0xc2,0xa0,0x00,0x18,0x1c,0x22, // tone freq 699,1Hz - vol 15 (max) swept down - length 24
						0xc2,0xbe,0x00,0x0c,0x1c,0x22, // tone freq 588,7Hz - vol 15 (max) swept down - length 12
						0xc2,0xd6,0x00,0x0c,0x1c,0x22, // tone freq 522,7Hz - vol 15 (max) swept down - length 12
						0xc2,0xbe,0x00,0x0c,0x1c,0x22, // tone freq 588,7Hz - vol 15 (max) swept down - length 12
						0xc2,0xf0,0x20,0x18,0x1c,0x22, // tone freq 466,1Hz - vol 13 swept down - length 24
						0xd0]; //end
					sndtable[1] = [
						0x82,0x81,0x22,0x18,0x1c,0x22, // tone freq 174,5Hz - vol 13 swept down - length 24
						0x82,0x57,0x23,0x18,0x1c,0x22, // tone freq 130,8Hz - vol 13 swept down - length 24
						0x82,0x81,0x22,0x18,0x1c,0x22, // tone freq 174,5Hz - vol 13 swept down - length 24
						0x82,0x57,0x23,0x18,0x1c,0x22, // tone freq 130,8Hz - vol 13 swept down - length 24
						0x82,0xbf,0x23,0x0c,0x1c,0x22, // tone freq 116,6Hz - vol 13 swept down - length 12
						0x82,0x57,0x23,0x06,0x1c,0x22, // tone freq 130,8Hz - vol 13 swept down - length 6
						0x82,0xfa,0x22,0x06,0x1c,0x22, // tone freq 146,8Hz - vol 13 swept down - length 6
						0x82,0xca,0x22,0x06,0x1c,0x22, // tone freq 156,7Hz - vol 13 swept down - length 6
						0x82,0x81,0x22,0x06,0x1c,0x22, // tone freq 174,5Hz - vol 13 swept down - length 6
						0x82,0x3b,0x12,0x06,0x1c,0x22, // tone freq 195,9Hz - vol 14 swept down - length 6
						0x82,0xfc,0x11,0x06,0x1c,0x22, // tone freq 220,2Hz - vol 14 swept down - length 6
						0x82,0xe0,0x01,0x18,0x1c,0x22, // tone freq 233,0Hz - vol 15 (max) swept down - length 24
						0x90]; //end
					
					nbrtables = 2;
					break;
				
				case 1:
				
					// VICTORY PAUSE MUSIC
					sndtable[0] = [
						0x42, 0xfe, 0x30, 0x6e, 0x14, 0xff,  // tone freq 440,4Hz - vol 12 swept down - length 110
						0x40, 0xd6, 0x30, 0x0a,  // tone freq 522,7Hz - vol 12 - length 10
						0x41, 0xf0, 0x30, 0x02, 0xaa, 0x0e,  // tone freq 466,1Hz swept down - vol 12 - length 20
						0x40, 0xf0, 0x30, 0x3c,  // tone freq 466,1Hz - vol 12 - length 60
						0x42, 0x1d, 0x31, 0x64, 0x14, 0xff,  // tone freq 392,5Hz - vol 12 swept down - length 100
						0x40, 0x78, 0x40, 0x08,  // tone freq 932,2Hz - vol 11 - length 8
						0x62,  // rest - length 2
						0x40, 0x78, 0x30, 0x08,  // tone freq 932,2Hz - vol 12 - length 8
						0x62,  // rest - length 2
						0x40, 0x78, 0x20, 0x14,  // tone freq 932,2Hz - vol 13 - length 20
						0x40, 0x7f, 0x30, 0x14,  // tone freq 880,8Hz - vol 12 - length 20
						0x40, 0x8f, 0x40, 0x14,  // tone freq 782,2Hz - vol 11 - length 20
						0x42, 0x7f, 0x30, 0x64, 0x14, 0xff,  // tone freq 880,8Hz - vol 12 swept down - length 100
						0x40, 0x8f, 0x30, 0x14,  // tone freq 782,2Hz - vol 12 - length 20
						0x42, 0xa0, 0x30, 0x46, 0x14, 0xff,  // tone freq 699,1Hz - vol 12 swept down - length 70
						0x41, 0xa0, 0x40, 0x02, 0xaa, 0xef,  // tone freq 699,1Hz swept up - vol 11 - length 20
						0x41, 0x7f, 0x40, 0x02, 0xaa, 0x10,  // tone freq 880,8Hz swept down - vol 11 - length 20
						0x40, 0xa0, 0x30, 0x0a,  // tone freq 699,1Hz - vol 12 - length 10
						0x42, 0x7f, 0x30, 0x64, 0x14, 0xff,  // tone freq 880,8Hz - vol 12 swept down - length 100
						0x40, 0xa0, 0x40, 0x14,  // tone freq 699,1Hz - vol 11 - length 20
						0x42, 0xd6, 0x30, 0xdc, 0x18, 0xff,  // tone freq 522,7Hz - vol 12 swept down - length 220
						0x40, 0x8f, 0x50, 0x14,  // tone freq 782,2Hz - vol 10 - length 20
						0x42, 0xa0, 0x40, 0x50, 0x14, 0x5a,  // tone freq 699,1Hz - vol 11 swept down - length 80
						0x40, 0xa0, 0x30, 0x14,  // tone freq 699,1Hz - vol 12 - length 20
						0x40, 0xd6, 0x30, 0x14,  // tone freq 522,7Hz - vol 12 - length 20
						0x42, 0xf0, 0x40, 0x50, 0x14, 0x3f,  // tone freq 466,1Hz - vol 11 swept down - length 80
						0x41, 0xd6, 0x40, 0x02, 0xaa, 0xf4,  // tone freq 522,7Hz swept up - vol 11 - length 20
						0x41, 0xd6, 0x40, 0x02, 0xaa, 0x1a,  // tone freq 522,7Hz swept down - vol 11 - length 20
						0x42, 0xfe, 0x40, 0x50, 0x14, 0x5f,  // tone freq 440,4Hz - vol 11 swept down - length 80
						0x40, 0xd6, 0x30, 0x14,  // tone freq 522,7Hz - vol 12 - length 20
						0x40, 0xfe, 0x30, 0x14,  // tone freq 440,4Hz - vol 12 - length 20
						0x42, 0xf0, 0x40, 0x50, 0x14, 0x6f,  // tone freq 466,1Hz - vol 11 swept down - length 80
						0x41, 0xd6, 0x40, 0x02, 0xaa, 0xf4,  // tone freq 522,7Hz swept up - vol 11 - length 20
						0x41, 0xd6, 0x40, 0x02, 0xaa, 0x1a,  // tone freq 522,7Hz swept down - vol 11 - length 20
						0x40, 0x40, 0x31, 0x14,  // tone freq 349,6Hz - vol 12 - length 20
						0x40, 0xfe, 0x40, 0x14,  // tone freq 440,4Hz - vol 11 - length 20
						0x40, 0xd6, 0x50, 0x14,  // tone freq 522,7Hz - vol 10 - length 20
						0x42, 0x8f, 0x60, 0x28, 0x14, 0x5f,  // tone freq 782,2Hz - vol 9 swept down - length 40
						0x58];  // repeat
					 
					sndtable[1] = [
						0xb4,  // rest - length 20
						0x80, 0xac, 0x31, 0x3c,  // tone freq 261,4Hz - vol 12 - length 60
						0x82, 0xac, 0x31, 0x1e, 0x14, 0x35,  // tone freq 261,4Hz - vol 12 swept down - length 30
						0x80, 0xfe, 0x30, 0x0a,  // tone freq 440,4Hz - vol 12 - length 10
						0x81, 0x1d, 0x31, 0x02, 0xaa, 0x23,  // tone freq 392,5Hz swept down - vol 12 - length 20
						0x82, 0x7d, 0x41, 0xa0, 0x14, 0xff,  // tone freq 293,6Hz - vol 11 swept down - length 160
						0x80, 0xbe, 0x40, 0x08,  // tone freq 588,7Hz - vol 11 - length 8
						0xa2,  // rest - length 2
						0x80, 0xbe, 0x30, 0x08,  // tone freq 588,7Hz - vol 12 - length 8
						0xa2,  // rest - length 2
						0x80, 0xbe, 0x20, 0x14,  // tone freq 588,7Hz - vol 13 - length 20
						0x80, 0xd6, 0x30, 0x14,  // tone freq 522,7Hz - vol 12 - length 20
						0x80, 0xf0, 0x40, 0x14,  // tone freq 466,1Hz - vol 11 - length 20
						0x82, 0xd6, 0x40, 0x64, 0x14, 0xff,  // tone freq 522,7Hz - vol 11 swept down - length 100
						0x80, 0xca, 0x30, 0x14,  // tone freq 553,8Hz - vol 12 - length 20
						0x82, 0xbe, 0x40, 0x46, 0x14, 0xff,  // tone freq 588,7Hz - vol 11 swept down - length 70
						0x81, 0xbe, 0x40, 0x02, 0xaa, 0xeb,  // tone freq 588,7Hz swept up - vol 11 - length 20
						0x81, 0xa0, 0x40, 0x02, 0xaa, 0x0a,  // tone freq 699,1Hz swept down - vol 11 - length 20
						0x80, 0xbe, 0x30, 0x0a,  // tone freq 588,7Hz - vol 12 - length 10
						0x82, 0xa0, 0x40, 0x64, 0x14, 0xff,  // tone freq 699,1Hz - vol 11 swept down - length 100
						0x80, 0xbe, 0x40, 0x14,  // tone freq 588,7Hz - vol 11 - length 20
						0x82, 0xfe, 0x40, 0xdc, 0x18, 0xff,  // tone freq 440,4Hz - vol 11 swept down - length 220
						0x80, 0xf0, 0x50, 0x14,  // tone freq 466,1Hz - vol 10 - length 20
						0x82, 0xfe, 0x40, 0x50, 0x14, 0xff,  // tone freq 440,4Hz - vol 11 swept down - length 80
						0x80, 0xd6, 0x30, 0x14,  // tone freq 522,7Hz - vol 12 - length 20
						0x80, 0xfe, 0x30, 0x14,  // tone freq 440,4Hz - vol 12 - length 20
						0x82, 0x40, 0x41, 0x50, 0x14, 0xff,  // tone freq 349,6Hz - vol 11 swept down - length 80
						0x81, 0xfe, 0x40, 0x02, 0xaa, 0xf2,  // tone freq 440,4Hz swept up - vol 11 - length 20
						0x81, 0xfe, 0x40, 0x02, 0xaa, 0x1f,  // tone freq 440,4Hz swept down - vol 11 - length 20
						0x82, 0x40, 0x41, 0x50, 0x14, 0xff,  // tone freq 349,6Hz - vol 11 swept down - length 80
						0x80, 0xfe, 0x30, 0x14,  // tone freq 440,4Hz - vol 12 - length 20
						0x80, 0x40, 0x31, 0x14,  // tone freq 349,6Hz - vol 12 - length 20
						0x82, 0x94, 0x41, 0x46, 0x14, 0xff,  // tone freq 276,9Hz - vol 11 swept down - length 70
						0x80, 0x1d, 0x41, 0x0a,  // tone freq 392,5Hz - vol 11 - length 10
						0x81, 0xfe, 0x40, 0x02, 0xaa, 0xf2,  // tone freq 440,4Hz swept up - vol 11 - length 20
						0x81, 0xfe, 0x40, 0x02, 0xaa, 0x1f,  // tone freq 440,4Hz swept down - vol 11 - length 20
						0x80, 0x40, 0x51, 0x28,  // tone freq 349,6Hz - vol 10 - length 40
						0x80, 0xfe, 0x60, 0x14,  // tone freq 440,4Hz - vol 9 - length 20
						0x82, 0xd6, 0x60, 0x28, 0x14, 0x5f,  // tone freq 522,7Hz - vol 9 swept down - length 40
						0x98];  // repeat
					 
					sndtable[2] = [
						0xea,  // rest - length 10
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x1e,  // tone freq 220,2Hz - vol 11 - length 30
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x28,  // tone freq 220,2Hz - vol 11 - length 40
						0xc1, 0x81, 0x32, 0x02, 0xaa, 0x79,  // tone freq 174,5Hz swept down - vol 12 - length 20
						0xc0, 0xe0, 0x41, 0x1e,  // tone freq 233,0Hz - vol 11 - length 30
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0xfa, 0x42, 0x0a,  // tone freq 146,8Hz - vol 11 - length 10
						0xc0, 0xe0, 0x41, 0x1e,  // tone freq 233,0Hz - vol 11 - length 30
						0xc0, 0x81, 0x42, 0x14,  // tone freq 174,5Hz - vol 11 - length 20
						0xc0, 0xfa, 0x52, 0x0a,  // tone freq 146,8Hz - vol 10 - length 10
						0xc0, 0xe0, 0x51, 0x1e,  // tone freq 233,0Hz - vol 10 - length 30
						0xc0, 0x81, 0x52, 0x14,  // tone freq 174,5Hz - vol 10 - length 20
						0xc0, 0xfa, 0x52, 0x0a,  // tone freq 146,8Hz - vol 10 - length 10
						0xc0, 0xe0, 0x51, 0x1e,  // tone freq 233,0Hz - vol 10 - length 30
						0xc0, 0x81, 0x52, 0x14,  // tone freq 174,5Hz - vol 10 - length 20
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x1e,  // tone freq 220,2Hz - vol 11 - length 30
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x0a,  // tone freq 220,2Hz - vol 11 - length 10
						0xc0, 0xf8, 0x23, 0x0a,  // tone freq 110,1Hz - vol 13 - length 10
						0xc1, 0xa7, 0x32, 0x02, 0xaa, 0x94,  // tone freq 164,7Hz swept up - vol 12 - length 20
						0xc0, 0xfa, 0x32, 0x0a,  // tone freq 146,8Hz - vol 12 - length 10
						0xc0, 0xfc, 0x41, 0x0a,  // tone freq 220,2Hz - vol 11 - length 10
						0xc2, 0x40, 0x41, 0x28, 0x14, 0x6f,  // tone freq 349,6Hz - vol 11 swept down - length 40
						0xc0, 0xfa, 0x32, 0x0a,  // tone freq 146,8Hz - vol 12 - length 10
						0xc0, 0xfc, 0x41, 0x0a,  // tone freq 220,2Hz - vol 11 - length 10
						0xc2, 0x40, 0x41, 0x28, 0x14, 0x6f,  // tone freq 349,6Hz - vol 11 swept down - length 40
						0xc0, 0x3b, 0x32, 0x0a,  // tone freq 195,9Hz - vol 12 - length 10
						0xc0, 0x7d, 0x41, 0x0a,  // tone freq 293,6Hz - vol 11 - length 10
						0xc2, 0xe2, 0x40, 0x1e, 0x14, 0x3f,  // tone freq 495,0Hz - vol 11 swept down - length 30
						0xc0, 0x3b, 0x32, 0x14,  // tone freq 195,9Hz - vol 12 - length 20
						0xc0, 0x7d, 0x41, 0x0a,  // tone freq 293,6Hz - vol 11 - length 10
						0xc0, 0xe2, 0x40, 0x14,  // tone freq 495,0Hz - vol 11 - length 20
						0xc2, 0xc5, 0x41, 0x14, 0x14, 0x3a,  // tone freq 246,9Hz - vol 11 swept down - length 20
						0xc0, 0x57, 0x33, 0x0a,  // tone freq 130,8Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0xac, 0x41, 0x28, 0x14, 0x6f,  // tone freq 261,4Hz - vol 11 swept down - length 40
						0xc0, 0x57, 0x33, 0x0a,  // tone freq 130,8Hz - vol 12 - length 10
						0xc0, 0xe0, 0x31, 0x0a,  // tone freq 233,0Hz - vol 12 - length 10
						0xc2, 0x7d, 0x31, 0x28, 0x13, 0x6f,  // tone freq 293,6Hz - vol 12 swept down - length 40
						0xc0, 0x57, 0x33, 0x0a,  // tone freq 130,8Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0xac, 0x51, 0x28, 0x13, 0x6f,  // tone freq 261,4Hz - vol 10 swept down - length 40
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x51, 0x0a,  // tone freq 220,2Hz - vol 10 - length 10
						0xc0, 0xe0, 0x61, 0x14,  // tone freq 233,0Hz - vol 9 - length 20
						0xc0, 0x81, 0x52, 0x1e,  // tone freq 174,5Hz - vol 10 - length 30
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x1e,  // tone freq 220,2Hz - vol 11 - length 30
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x14,  // tone freq 220,2Hz - vol 11 - length 20
						0xc2, 0xfe, 0x40, 0x14, 0x14, 0x3a,  // tone freq 440,4Hz - vol 11 swept down - length 20
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0x1d, 0x41, 0x28, 0x14, 0x6f,  // tone freq 392,5Hz - vol 11 swept down - length 40
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0x1d, 0x41, 0x28, 0x14, 0x6f,  // tone freq 392,5Hz - vol 11 swept down - length 40
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc0, 0xfc, 0x41, 0x1e,  // tone freq 220,2Hz - vol 11 - length 30
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0x57, 0x43, 0x0a,  // tone freq 130,8Hz - vol 11 - length 10
						0xc2, 0xfc, 0x41, 0x28, 0x14, 0x6f,  // tone freq 220,2Hz - vol 11 swept down - length 40
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0x1d, 0x41, 0x28, 0x14, 0x6f,  // tone freq 392,5Hz - vol 11 swept down - length 40
						0xc0, 0x81, 0x32, 0x0a,  // tone freq 174,5Hz - vol 12 - length 10
						0xc0, 0xe0, 0x41, 0x0a,  // tone freq 233,0Hz - vol 11 - length 10
						0xc2, 0x1d, 0x41, 0x28, 0x14, 0x6f,  // tone freq 392,5Hz - vol 11 swept down - length 40
						0xc0, 0x81, 0x32, 0x14,  // tone freq 174,5Hz - vol 12 - length 20
						0xc0, 0xfc, 0x41, 0x14,  // tone freq 220,2Hz - vol 11 - length 20
						0xc0, 0xac, 0x51, 0x14,  // tone freq 261,4Hz - vol 10 - length 20
						0xc2, 0x40, 0x61, 0x28, 0x14, 0x5f,  // tone freq 349,6Hz - vol 9 swept down - length 40
						0xd8];  // repeat
					
					nbrtables = 3;
					break;
					
				case 2:
				
				// ROCKY INTRO
					sndtable[0] = [
						0x42,0x28,0x70,0x0d,0xe4,0x11,  // tone freq 2796,5Hz - vol 8 swept up - length 13
						0x63,  // rest - length 3
						0x42,0x28,0x70,0x0d,0xe4,0x11,  // tone freq 2796,5Hz - vol 8 swept up - length 13
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x42,0x28,0x70,0x10,0xe4,0x11,  // tone freq 2796,5Hz - vol 8 swept up - length 16
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x42,0x20,0x90,0x10,0xe4,0x11,  // tone freq 3495,6Hz - vol 6 swept up - length 16
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x63,  // rest - length 3
						0x40,0x28,0x30,0x05,  // tone freq 2796,5Hz - vol 12 - length 5
						0x42,0x28,0x70,0x20,0xe4,0x11,  // tone freq 2796,5Hz - vol 8 swept up - length 32
						0x63,  // rest - length 3
						0x42,0x1e,0x90,0x0d,0xe4,0x11,  // tone freq 3728,7Hz - vol 6 swept up - length 13
						0x63,  // rest - length 3
						0x40,0x1e,0x50,0x05,  // tone freq 3728,7Hz - vol 10 - length 5
						0x63,  // rest - length 3
						0x40,0x1e,0x50,0x05,  // tone freq 3728,7Hz - vol 10 - length 5
						0x42,0x20,0x90,0x10,0xe4,0x11,  // tone freq 3495,6Hz - vol 6 swept up - length 16
						0x63,  // rest - length 3
						0x40,0x20,0x50,0x05,  // tone freq 3495,6Hz - vol 10 - length 5
						0x42,0x24,0x90,0x10,0xe4,0x11,  // tone freq 3107,2Hz - vol 6 swept up - length 16
						0x63,  // rest - length 3
						0x41,0x24,0x50,0x02,0x08,0x04,  // tone freq 3107,2Hz swept down - vol 10 - length 24
						0x40,0xbf,0x23,0x20,  // tone freq 116,6Hz - vol 13 - length 32
						0x42,0xf8,0x23,0xed,0x18,0xff,  // tone freq 110,1Hz - vol 13 swept down - length 237
						0x50];  // end
						
					sndtable[1] = [
						0x82,0xe0,0x71,0x0d,0xe4,0x11,  // tone freq 233,0Hz - vol 8 swept up - length 13
						0xa3,  // rest - length 3
						0x82,0xe0,0x71,0x0d,0xe4,0x11,  // tone freq 233,0Hz - vol 8 swept up - length 13
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0x82,0xe0,0x71,0x10,0xe4,0x11,  // tone freq 233,0Hz - vol 8 swept up - length 16
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0x82,0x7d,0x71,0x10,0xe4,0x11,  // tone freq 293,6Hz - vol 8 swept up - length 16
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0xa3,  // rest - length 3
						0x80,0xe0,0x31,0x05,  // tone freq 233,0Hz - vol 12 - length 5
						0x82,0xe0,0x71,0x20,0xe4,0x11,  // tone freq 233,0Hz - vol 8 swept up - length 32
						0xa3,  // rest - length 3
						0x82,0x68,0x71,0x0d,0xe4,0x11,  // tone freq 310,7Hz - vol 8 swept up - length 13
						0xa3,  // rest - length 3
						0x80,0x68,0x31,0x05,  // tone freq 310,7Hz - vol 12 - length 5
						0xa3,  // rest - length 3
						0x80,0x68,0x31,0x05,  // tone freq 310,7Hz - vol 12 - length 5
						0x82,0x7d,0x71,0x10,0xe4,0x11,  // tone freq 293,6Hz - vol 8 swept up - length 16
						0xa3,  // rest - length 3
						0x80,0x7d,0x31,0x05,  // tone freq 293,6Hz - vol 12 - length 5
						0x82,0xac,0x71,0x10,0xe4,0x11,  // tone freq 261,4Hz - vol 8 swept up - length 16
						0xa3,  // rest - length 3
						0x80,0xac,0x31,0x08,  // tone freq 261,4Hz - vol 12 - length 8
						0x80,0xe0,0x31,0x30,  // tone freq 233,0Hz - vol 12 - length 48
						0x81,0xf8,0x23,0x80,0x11,0xfb,  // tone freq 110,1Hz swept up - vol 13 - length 128
						0x83,0x7e,0x31,0x80,0x11,0xfe,0x1c,0xaa,  // tone freq 292,8Hz swept up - vol 12 swept down - length 128
						0x90];  // end
						
					sndtable[2] = [
						0xc2,0x78,0x90,0x0d,0xe4,0x11,  // tone freq 932,2Hz - vol 6 swept up - length 13
						0xe3,  // rest - length 3
						0xc2,0x78,0x90,0x0d,0xe4,0x11,  // tone freq 932,2Hz - vol 6 swept up - length 13
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xc2,0x78,0x90,0x10,0xe4,0x11,  // tone freq 932,2Hz - vol 6 swept up - length 16
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xc2,0x5f,0x90,0x10,0xe4,0x11,  // tone freq 1177,5Hz - vol 6 swept up - length 16
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xe3,  // rest - length 3
						0xc0,0x78,0x50,0x05,  // tone freq 932,2Hz - vol 10 - length 5
						0xc2,0x78,0x90,0x20,0xe4,0x11,  // tone freq 932,2Hz - vol 6 swept up - length 32
						0xe3,  // rest - length 3
						0xc2,0x5a,0x90,0x0d,0xe4,0x11,  // tone freq 1242,9Hz - vol 6 swept up - length 13
						0xe3,  // rest - length 3
						0xc0,0x5a,0x50,0x05,  // tone freq 1242,9Hz - vol 10 - length 5
						0xe3,  // rest - length 3
						0xc0,0x5a,0x50,0x05,  // tone freq 1242,9Hz - vol 10 - length 5
						0xc2,0x5a,0x90,0x10,0xe4,0x11,  // tone freq 1242,9Hz - vol 6 swept up - length 16
						0xe3,  // rest - length 3
						0xc0,0x5a,0x50,0x05,  // tone freq 1242,9Hz - vol 10 - length 5
						0xc2,0x5a,0x90,0x10,0xe4,0x11,  // tone freq 1242,9Hz - vol 6 swept up - length 16
						0xe3,  // rest - length 3
						0xc0,0x5a,0x50,0x08,  // tone freq 1242,9Hz - vol 10 - length 8
						0xc0,0x5a,0x30,0x10,  // tone freq 1242,9Hz - vol 12 - length 16
						0xc0,0x80,0xb0,0x20,  // tone freq 873,9Hz - vol 4 - length 32
						0xc0,0x88,0xd0,0xed,  // tone freq 822,5Hz - vol 2 - length 237
						0xd0];  // end
						
					sndtable[3] = [
						0x30,  // rest - length 16
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x26,0x20,0x44,0x13,  // white noise - freq 874 Hz - vol 13 swept down - length 32
						0x02,0x13,0x80,0x00,0x00,  // periodic noise - freq channel 3 - vol 14 - length 128
						0x02,0x13,0x80,0x1d,0xff,  // periodic noise - freq channel 3 - vol 14 swept down - length 128
						0x10];  // end
						
					nbrtables = 4;
					break;
					
				case 3:
					
					// SPACE FURY INTRO
					sndtable[0] = [
						0x38,  // rest - length 24
						0x41,0xe2,0x20,0x06,0x1a,0xf6,  // tone freq 495,0Hz swept up - vol 13 - length 15
						0x41,0xaa,0x20,0x06,0x1a,0xf6,  // tone freq 658,0Hz swept up - vol 13 - length 15
						0x40,0x71,0x20,0x60,  // tone freq 989,9Hz - vol 13 - length 96
						0x42,0x71,0x20,0x5a,0x1d,0x16,  // tone freq 989,9Hz - vol 13 swept down - length 90
						0x41,0xaa,0x20,0x06,0x1a,0xf6,  // tone freq 658,0Hz swept up - vol 13 - length 15
						0x41,0x71,0x20,0x06,0x1a,0x01,  // tone freq 989,9Hz swept down - vol 13 - length 15
						0x40,0x7f,0x20,0x60,  // tone freq 880,8Hz - vol 13 - length 96
						0x42,0x7f,0x20,0x5a,0x1d,0x16,  // tone freq 880,8Hz - vol 13 swept down - length 90
						0x40,0x65,0x20,0x30,  // tone freq 1107,5Hz - vol 13 - length 48
						0x40,0x7f,0x20,0x30,  // tone freq 880,8Hz - vol 13 - length 48
						0x40,0xaa,0x20,0x30,  // tone freq 658,0Hz - vol 13 - length 48
						0x40,0xe2,0x20,0x60,  // tone freq 495,0Hz - vol 13 - length 96
						0x10];
					
					sndtable[1] = [
						0x38,  // rest - length 24
						0x81,0x53,0x21,0x06,0x1a,0xf6,  // tone freq 330,0Hz swept up - vol 13 - length 15
						0x81,0xe2,0x20,0x06,0x1a,0xf6,  // tone freq 495,0Hz swept up - vol 13 - length 15
						0x80,0xaa,0x20,0x60,  // tone freq 658,0Hz - vol 13 - length 96
						0x82,0xaa,0x20,0x5a,0x1d,0x16,  // tone freq 658,0Hz - vol 13 swept down - length 90
						0x81,0xe2,0x20,0x06,0x1a,0xf6,  // tone freq 495,0Hz swept up - vol 13 - length 15
						0x81,0xaa,0x20,0x06,0x1a,0x06,  // tone freq 658,0Hz swept down - vol 13 - length 15
						0x80,0xca,0x20,0x60,  // tone freq 553,8Hz - vol 13 - length 96
						0x82,0xca,0x20,0x5a,0x1d,0x16,  // tone freq 553,8Hz - vol 13 swept down - length 90
						0x80,0xaa,0x20,0x30,  // tone freq 658,0Hz - vol 13 - length 48
						0x80,0xca,0x20,0x30,  // tone freq 553,8Hz - vol 13 - length 48
						0x80,0xff,0x20,0x30,  // tone freq 438,7Hz - vol 13 - length 48
						0x80,0x53,0x20,0x60,  // tone freq 1347,7Hz - vol 13 - length 96
						0x10];
					
					sndtable[2] = [
						0xc0,0xa7,0x22,0x60,  // tone freq 164,7Hz - vol 13 - length 96
						0xc1,0x72,0x40,0x06,0x1a,0xfa,  // tone freq 981,2Hz swept up - vol 11 - length 15
						0xc1,0x55,0x40,0x06,0x1a,0xfb,  // tone freq 1316,0Hz swept up - vol 11 - length 15
						0xc0,0x39,0x40,0x18,  // tone freq 1962,5Hz - vol 11 - length 24
						0xc2,0x39,0x40,0x42,0x1b,0x13,  // tone freq 1962,5Hz - vol 11 swept down - length 66
						0xc0,0xf8,0x23,0x60,  // tone freq 110,1Hz - vol 13 - length 96
						0xc1,0x55,0x20,0x06,0x1a,0xfb,  // tone freq 1316,0Hz swept up - vol 13 - length 15
						0xc1,0x39,0x20,0x06,0x1a,0x01,  // tone freq 1962,5Hz swept down - vol 13 - length 15
						0xc0,0x40,0x20,0x18,  // tone freq 1747,8Hz - vol 13 - length 24
						0xc2,0x40,0x20,0x42,0x1d,0x13,  // tone freq 1747,8Hz - vol 13 swept down - length 66
						0xc0,0xf8,0x23,0x18,  // tone freq 110,1Hz - vol 13 - length 24
						0xc0,0xa7,0x22,0x18,  // tone freq 164,7Hz - vol 13 - length 24
						0xc0,0xfc,0x21,0x18,  // tone freq 220,2Hz - vol 13 - length 24
						0xc0,0x53,0x21,0x18,  // tone freq 330,0Hz - vol 13 - length 24
						0xc0,0xfe,0x20,0x18,  // tone freq 440,4Hz - vol 13 - length 24
						0xc0,0xab,0x20,0x18,  // tone freq 654,2Hz - vol 13 - length 24
						0xc1,0x7f,0x20,0x60,0x1f,0xff,  // tone freq 880,8Hz swept up - vol 13 - length 110
						0x10];
					
					nbrtables = 3;
					break;
					
				case 4:
				
					// BOULDERDASH MUSIC
					sndtable[0] = [
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xa5,0x31,0x07, // tone freq 265,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x0c,0x31,0x07, // tone freq 417,4Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7b,0x31,0x07, // tone freq 295,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x24,0x33,0x07, // tone freq 139,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x24,0x33,0x07, // tone freq 139,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x92,0x31,0x07, // tone freq 278,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x24,0x33,0x07, // tone freq 139,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x52,0x31,0x07, // tone freq 330,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x86,0x30,0x07, // tone freq 834,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x92,0x31,0x07, // tone freq 278,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x92,0x31,0x07, // tone freq 278,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x92,0x31,0x07, // tone freq 278,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x92,0x31,0x07, // tone freq 278,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xc3,0x31,0x07, // tone freq 248,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xc3,0x31,0x07, // tone freq 248,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xc3,0x31,0x07, // tone freq 248,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xc3,0x31,0x07, // tone freq 248,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x53,0x33,0x07, // tone freq 131,4Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x53,0x33,0x07, // tone freq 131,4Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xbc,0x33,0x07, // tone freq 117,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xbc,0x33,0x07, // tone freq 117,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x86,0x30,0x07, // tone freq 834,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x6a,0x30,0x07, // tone freq 1055,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x86,0x30,0x07, // tone freq 834,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7e,0x32,0x07, // tone freq 175,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x86,0x30,0x07, // tone freq 834,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xfd,0x30,0x07, // tone freq 442,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x6a,0x30,0x07, // tone freq 1055,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0xc0,0xcc,0x32,0x07, // tone freq 156,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x18]; // repeat
						
					sndtable[1] = [
						0x80,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xfd,0x30,0x07, // tone freq 442,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xc9,0x30,0x07, // tone freq 556,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x86,0x30,0x07, // tone freq 834,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x5f,0x30,0x07, // tone freq 1177,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xa9,0x30,0x07, // tone freq 661,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x6a,0x30,0x07, // tone freq 1055,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xa5,0x31,0x07, // tone freq 265,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xa5,0x31,0x07, // tone freq 265,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x1c,0x31,0x07, // tone freq 393,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xc9,0x30,0x07, // tone freq 556,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x50,0x30,0x07, // tone freq 1398,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xc9,0x30,0x07, // tone freq 556,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xde,0x31,0x07, // tone freq 234,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x3f,0x31,0x07, // tone freq 350,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xe1,0x30,0x07, // tone freq 497,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x59,0x30,0x07, // tone freq 1256,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xe1,0x30,0x07, // tone freq 497,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xa5,0x31,0x07, // tone freq 265,7Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xa9,0x30,0x07, // tone freq 661,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x7b,0x31,0x07, // tone freq 295,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x50,0x30,0x07, // tone freq 1398,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x59,0x30,0x07, // tone freq 1256,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x5f,0x30,0x07, // tone freq 1177,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x6a,0x30,0x07, // tone freq 1055,3Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x59,0x30,0x07, // tone freq 1256,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x59,0x30,0x07, // tone freq 1256,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x77,0x30,0x07, // tone freq 940,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x59,0x30,0x07, // tone freq 1256,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xfd,0x30,0x07, // tone freq 442,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x7f,0x30,0x07, // tone freq 880,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x9f,0x30,0x07, // tone freq 703,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xd5,0x30,0x07, // tone freq 525,2Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xfd,0x30,0x07, // tone freq 442,1Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x8e,0x30,0x07, // tone freq 787,8Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xb3,0x30,0x07, // tone freq 624,9Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0xef,0x30,0x07, // tone freq 468,0Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x80,0x66,0x31,0x07, // tone freq 312,5Hz - vol 12 - length 7
						0x21, // rest - length 1
						0x18]; // repeat
						
					nbrtables = 2;
					break;
					
					
				case 5:
				
					// VENTURE BONUS SOUND EFFECT
					sndtable[0] = [
						0x83,0xa1,0x02,0x40,0x11,0x7f,0x00,0x88, // tone freq 166,2Hz swept down - vol 15 (max) - length 64
						0x90];
					nbrtables = 1;
					break;
					
				case 6:
					// TIME PILOT INTO
					sndtable[0] = [
						0x7e, // rest - length 30
						0x6e, // rest - length 14
						0x76, // rest - length 22
						0x40,0xf0,0x20,0x0c, // tone freq 466,1Hz - vol 13 - length 12
						0x22, // rest - length 2
						0x40,0xfe,0x20,0x30, // tone freq 440,4Hz - vol 13 - length 48
						0x24, // rest - length 4
						0x42,0xf0,0x20,0x16,0x18,0x15, // tone freq 466,1Hz - vol 13 swept down - length 22
						0x40,0xfe,0x20,0x0c, // tone freq 440,4Hz - vol 13 - length 12
						0x22, // rest - length 2
						0x40,0xd6,0x20,0x4a, // tone freq 522,7Hz - vol 13 - length 74
						0x42,0xd6,0x20,0x0e,0x26,0x12, // tone freq 522,7Hz - vol 13 swept down - length 14
						0x42,0xd6,0x20,0x08,0x24,0x12, // tone freq 522,7Hz - vol 13 swept down - length 8
						0x41,0xb4,0x20,0x02,0x78,0x0a, // tone freq 621,4Hz swept down - vol 13 - length 15
						0x42,0xd6,0x20,0x07,0x23,0x13, // tone freq 522,7Hz - vol 13 swept down - length 7
						0x41,0xd6,0x20,0x02,0x78,0x0c, // tone freq 522,7Hz swept down - vol 13 - length 15
						0x42,0xfe,0x20,0x07,0x23,0x13, // tone freq 440,4Hz - vol 13 swept down - length 7
						0x41,0xfe,0x20,0x02,0x78,0x0f, // tone freq 440,4Hz swept down - vol 13 - length 15
						0x42,0x40,0x21,0x07,0x23,0x13, // tone freq 349,6Hz - vol 13 swept down - length 7
						0x41,0x40,0x21,0x02,0x78,0xcd, // tone freq 349,6Hz swept up - vol 13 - length 15
						0x41,0xfe,0x20,0x02,0x67,0x42, // tone freq 440,4Hz swept down - vol 13 - length 13
						0x50]; // end
					sndtable[1] = [
						0xbe, // rest - length 30
						0xae, // rest - length 14
						0xb6, // rest - length 22
						0x80,0xef,0x40,0x0c, // tone freq 468,0Hz - vol 11 - length 12
						0x22, // rest - length 2
						0x80,0xfd,0x40,0x30, // tone freq 442,1Hz - vol 11 - length 48
						0x24, // rest - length 4
						0x82,0xef,0x40,0x16,0x18,0x15, // tone freq 468,0Hz - vol 11 swept down - length 22
						0x80,0xfd,0x40,0x0c, // tone freq 442,1Hz - vol 11 - length 12
						0x22, // rest - length 2
						0x80,0xd5,0x40,0x4a, // tone freq 525,2Hz - vol 11 - length 74
						0x82,0xd5,0x40,0x0e,0x26,0x12, // tone freq 525,2Hz - vol 11 swept down - length 14
						0x82,0xd5,0x40,0x08,0x24,0x12, // tone freq 525,2Hz - vol 11 swept down - length 8
						0x81,0xb3,0x40,0x02,0x78,0x0a, // tone freq 624,9Hz swept down - vol 11 - length 15
						0x82,0xd5,0x40,0x07,0x23,0x13, // tone freq 525,2Hz - vol 11 swept down - length 7
						0x81,0xd5,0x40,0x02,0x78,0x0c, // tone freq 525,2Hz swept down - vol 11 - length 15
						0x82,0xfd,0x40,0x07,0x23,0x13, // tone freq 442,1Hz - vol 11 swept down - length 7
						0x81,0xfd,0x40,0x02,0x78,0x0f, // tone freq 442,1Hz swept down - vol 11 - length 15
						0x82,0x3f,0x41,0x07,0x23,0x13, // tone freq 350,7Hz - vol 11 swept down - length 7
						0x81,0x3f,0x41,0x02,0x78,0xcd, // tone freq 350,7Hz swept up - vol 11 - length 15
						0x81,0xfd,0x40,0x02,0x67,0x42, // tone freq 442,1Hz swept down - vol 11 - length 13
						0x90]; // end
					sndtable[2] = [
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0xa7,0x22,0x08,0x33,0x12, // tone freq 164,7Hz - vol 13 swept down - length 8
						0xc2,0x81,0x22,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 13 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x81,0x32,0x0e,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 14
						0xc2,0x81,0x32,0x08,0x33,0x12, // tone freq 174,5Hz - vol 12 swept down - length 8
						0xc2,0x57,0x33,0x0e,0x33,0x12, // tone freq 130,8Hz - vol 12 swept down - length 14
						0xc2,0x57,0x33,0x08,0x33,0x12, // tone freq 130,8Hz - vol 12 swept down - length 8
						0xc2,0xf8,0x33,0x0e,0x33,0x12, // tone freq 110,1Hz - vol 12 swept down - length 14
						0xe8, // rest - length 8
						0xc2,0xbf,0x33,0x0e,0x33,0x12, // tone freq 116,6Hz - vol 12 swept down - length 14
						0xe8, // rest - length 8
						0xc2,0x57,0x33,0x0e,0x33,0x12, // tone freq 130,8Hz - vol 12 swept down - length 14
						0xe8, // rest - length 8
						0xc0,0x60,0xf0,0x58, // rest - length 88
						0xc0,0x56,0xf0,0x08, // rest - length 8
						0xd0]; // end
					sndtable[3] = [
						0x02,0xf3,0xff,0x00,0x00, // periodic noise - freq channel 3 - vol 0 (off) - length 255
						0x28, // rest - length 8
						0x02,0x33,0x58,0x15,0xfd, // periodic noise - freq channel 3 - vol 12 swept down - length 88
						0x02,0x33,0x08,0x23,0x14, // periodic noise - freq channel 3 - vol 12 swept down - length 8
						0x10]; // end
					nbrtables = 4;
					break;
				
				case 7:
				
					// TIME PILOT PAUSE MUSIC LOOP
				
					sndtable[0] = [
						0x40,0x00,0xf0,0xb4, // rest - length 180
						0x42,0x0d,0x41,0x1e,0x17,0x2f, // tone freq 415,8Hz - vol 11 swept down - length 30
						0x42,0x53,0x41,0x0f,0x16,0x19, // tone freq 330,0Hz - vol 11 swept down - length 15
						0x42,0xc5,0x41,0x2d,0x1a,0x3f, // tone freq 246,9Hz - vol 11 swept down - length 45
						0x42,0xe0,0x41,0x1e,0x17,0x2f, // tone freq 233,0Hz - vol 11 swept down - length 30
						0x42,0x1d,0x41,0x3c,0x15,0xaf, // tone freq 392,5Hz - vol 11 swept down - length 60
						0x7e, // rest - length 30
						0x42,0x0d,0x41,0x1e,0x17,0x2f, // tone freq 415,8Hz - vol 11 swept down - length 30
						0x42,0x53,0x41,0x1e,0x17,0x2f, // tone freq 330,0Hz - vol 11 swept down - length 30
						0x42,0xf0,0x40,0x5a,0x15,0xff, // tone freq 466,1Hz - vol 11 swept down - length 90
						0x42,0x0d,0x41,0x2d,0x1a,0x3f, // tone freq 415,8Hz - vol 11 swept down - length 45
						0x42,0xe2,0x40,0x2d,0x1a,0x3f, // tone freq 495,0Hz - vol 11 swept down - length 45
						0x41,0xf0,0x50,0x02,0xff,0x1d, // tone freq 466,1Hz swept down - vol 10 - length 30
						0x41,0x1d,0x61,0x02,0xff,0x36, // tone freq 392,5Hz swept down - vol 9 - length 30
						0x41,0x7d,0x71,0x02,0xff,0x48, // tone freq 293,6Hz swept down - vol 8 - length 30
						0x58]; // repeat
					sndtable[1] = [
						0x82,0xa7,0x42,0x0f,0x16,0x19, // tone freq 164,7Hz - vol 11 swept down - length 15
						0x82,0xc5,0x51,0x0f,0x16,0x19, // tone freq 246,9Hz - vol 10 swept down - length 15
						0x83,0x2e,0x61,0x04,0xff,0x9c,0x13,0xff, // tone freq 370,4Hz swept up - vol 9 swept down - length 60
						0x82,0x89,0x43,0x0f,0x16,0x19, // tone freq 123,6Hz - vol 11 swept down - length 15
						0x82,0x5d,0x52,0x0f,0x16,0x19, // tone freq 184,9Hz - vol 10 swept down - length 15
						0x82,0x94,0x61,0x0f,0x16,0x19, // tone freq 276,9Hz - vol 9 swept down - length 15
						0x83,0x0d,0x71,0x03,0xff,0xa7,0x12,0xff, // tone freq 415,8Hz swept up - vol 8 swept down - length 45
						0x98]; // repeat
					sndtable[2] = [
						0xc0,0x00,0xf0,0xb4, // rest - length 180
						0xc2,0x39,0x60,0x5a,0x15,0xff, // tone freq 1962,5Hz - vol 9 swept down - length 90
						0xc2,0x3c,0x60,0x5a,0x15,0xff, // tone freq 1864,3Hz - vol 9 swept down - length 90
						0xc2,0x43,0x60,0x5a,0x15,0xff, // tone freq 1669,6Hz - vol 9 swept down - length 90
						0xc2,0x47,0x60,0x5a,0x15,0xff, // tone freq 1575,5Hz - vol 9 swept down - length 90
						0xc2,0xaa,0x60,0x5a,0x15,0xff, // tone freq 658,0Hz - vol 9 swept down - length 90
						0xc2,0xb4,0x60,0x5a,0x15,0xff, // tone freq 621,4Hz - vol 9 swept down - length 90
						0xd8]; // repeat
					
					nbrtables = 3;
					break;
					
				case 8:
					// SLITHER PAUSE MUSIC
					
					sndtable[0] = [
						0x02,0x33,0x54,0x1c,0x29, // periodic noise - freq channel 3 - vol 12 swept down - length 84
						0x18]; // repeat
					sndtable[1] = [
						0xc0,0x5a,0xf0,0x1c, // rest - length 28
						0xc0,0x53,0x71,0x0e, // tone freq 330,0Hz - vol 8 - length 14
						0xc0,0x2e,0x51,0x1c, // tone freq 370,4Hz - vol 10 - length 28
						0xc0,0x53,0x71,0x0e, // tone freq 330,0Hz - vol 8 - length 14
						0xd8]; // repeat
					sndtable[2] = [
						0xc0,0x88,0xf0,0x2a, // rest - length 42
						0x80,0x00,0xf0,0x2a, // rest - length 42
						0xc0,0x44,0xf0,0x1c, // rest - length 28
						0x80,0x00,0xf0,0x62, // rest - length 98
						0xc0,0x53,0x51,0x2a, // tone freq 330,0Hz - vol 10 - length 42
						0xc0,0xfe,0x40,0x2a, // tone freq 440,4Hz - vol 11 - length 42
						0xc0,0xca,0x40,0x2a, // tone freq 553,8Hz - vol 11 - length 42
						0x82,0xaa,0x30,0xa8,0x1b,0x9f, // tone freq 658,0Hz - vol 12 swept down - length 168
						0xc0,0x44,0xf0,0x2a, // rest - length 42
						0x80,0x97,0x50,0x1c, // tone freq 740,8Hz - vol 10 - length 28
						0x80,0xaa,0x50,0x0e, // tone freq 658,0Hz - vol 10 - length 14
						0x80,0xca,0x40,0x2a, // tone freq 553,8Hz - vol 11 - length 42
						0x80,0xfe,0x50,0x2a, // tone freq 440,4Hz - vol 10 - length 42
						0x82,0xca,0x30,0xa8,0x1b,0x9f, // tone freq 553,8Hz - vol 12 swept down - length 168
						0xc0,0x44,0xf0,0x2a, // rest - length 42
						0x80,0x53,0x51,0x2a, // tone freq 330,0Hz - vol 10 - length 42
						0x80,0xfe,0x40,0x2a, // tone freq 440,4Hz - vol 11 - length 42
						0x80,0xca,0x40,0x2a, // tone freq 553,8Hz - vol 11 - length 42
						0x82,0xe2,0x30,0xa8,0x1b,0x9f, // tone freq 495,0Hz - vol 12 swept down - length 168
						0xc0,0x78,0xf0,0x2a, // rest - length 42
						0x80,0xca,0x50,0x1c, // tone freq 553,8Hz - vol 10 - length 28
						0x80,0xe2,0x40,0x0e, // tone freq 495,0Hz - vol 11 - length 14
						0x80,0xfe,0x30,0x2a, // tone freq 440,4Hz - vol 12 - length 42
						0x80,0x2e,0x41,0x2a, // tone freq 370,4Hz - vol 11 - length 42
						0x82,0xfe,0x60,0xd2,0x1a,0xef, // tone freq 440,4Hz - vol 9 swept down - length 210
						0x02,0x33,0x7e,0x00,0x00, // periodic noise - freq channel 3 - vol 12 - length 126
						0x98]; // repeat
					sndtable[3] = [
						0x40,0x00,0xf0,0xd2, // rest - length 210
						0x02,0xf3,0x54,0x00,0x00, // periodic noise - freq channel 3 - vol 0 (off) - length 84
						0x40,0x00,0xf0,0x2a, // rest - length 42
						0xc0,0x88,0xf0,0x2a, // rest - length 42
						0x40,0xfc,0x51,0x2a, // tone freq 220,2Hz - vol 10 - length 42
						0x40,0x94,0x41,0x2a, // tone freq 276,9Hz - vol 11 - length 42
						0x40,0x7d,0x41,0x2a, // tone freq 293,6Hz - vol 11 - length 42
						0x42,0x53,0x31,0xa8,0x1b,0x9f, // tone freq 330,0Hz - vol 12 swept down - length 168
						0xc0,0x88,0xf0,0x2a, // rest - length 42
						0x40,0xfc,0x51,0x2a, // tone freq 220,2Hz - vol 10 - length 42
						0x40,0x94,0x41,0x2a, // tone freq 276,9Hz - vol 11 - length 42
						0x40,0x7d,0x41,0x2a, // tone freq 293,6Hz - vol 11 - length 42
						0x42,0x53,0x31,0xa8,0x1b,0x9f, // tone freq 330,0Hz - vol 12 swept down - length 168
						0xc0,0xb4,0xf0,0x2a, // rest - length 42
						0x40,0xfc,0x51,0x2a, // tone freq 220,2Hz - vol 10 - length 42
						0x40,0x94,0x41,0x2a, // tone freq 276,9Hz - vol 11 - length 42
						0x40,0x7d,0x41,0x2a, // tone freq 293,6Hz - vol 11 - length 42
						0x42,0x53,0x31,0x54,0x14,0xff, // tone freq 330,0Hz - vol 12 swept down - length 84
						0x42,0x94,0x41,0x54,0x14,0xff, // tone freq 276,9Hz - vol 11 swept down - length 84
						0x42,0xfc,0x31,0x54,0x14,0xff, // tone freq 220,2Hz - vol 12 swept down - length 84
						0x42,0x94,0x41,0x54,0x14,0xff, // tone freq 276,9Hz - vol 11 swept down - length 84
						0x42,0xc5,0x31,0x2a,0x1c,0x1f, // tone freq 246,9Hz - vol 12 swept down - length 42
						0xc1,0xb4,0xf0,0x29,0x36,0xff, // tone freq 621,4Hz swept up - vol 0 (off) - length 126
						0x58]; // repeat
					
					nbrtables = 4;
					break;
					
				case 9:
						// PRESET NOISE TEST
						sndtable[0] = [
							0, 0, 0, 8, // periodic noise - freq 499 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0, 0, 1, 8, // periodic noise - freq 249 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0, 0, 2, 8, // periodic noise - freq 125 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0, 0, 4, 8, // white noise - freq 3495 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0, 0, 5, 8, // white noise - freq 1748 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0, 0, 6, 8, // white noise - freq 874 Hz - vol 15 (max) - length 8
							0x24, // rest - length 4
							0x10]; // end
					nbrtables = 1;
					break;
							
				case 10:
				
					sndtable[0] = [
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0x53,0x21,0x09,0x43,0x23, // tone freq 330,0Hz - vol 13 swept down - length 9
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0x53,0x21,0x09,0x43,0x23, // tone freq 330,0Hz - vol 13 swept down - length 9
					0x42,0x53,0x41,0x09,0x43,0x23, // tone freq 330,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x21,0x09,0x43,0x23, // tone freq 262,0Hz - vol 13 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0xab,0x21,0x09,0x43,0x23, // tone freq 262,0Hz - vol 13 swept down - length 9
					0x42,0xab,0x41,0x09,0x43,0x23, // tone freq 262,0Hz - vol 11 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x3a,0x22,0x09,0x43,0x23, // tone freq 196,2Hz - vol 13 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x3a,0x22,0x09,0x43,0x23, // tone freq 196,2Hz - vol 13 swept down - length 9
					0x42,0x3a,0x42,0x09,0x43,0x23, // tone freq 196,2Hz - vol 11 swept down - length 9
					0x42,0x7c,0x21,0x09,0x16,0x14, // tone freq 294,4Hz - vol 13 swept down - length 9
					0x69, // rest - length 9
					0x42,0xab,0x21,0x09,0x16,0x14, // tone freq 262,0Hz - vol 13 swept down - length 9
					0x69, // rest - length 9
					0x42,0xc4,0x21,0x09,0x16,0x14, // tone freq 247,5Hz - vol 13 swept down - length 9
					0x69, // rest - length 9
					0x42,0xfc,0x21,0x09,0x16,0x14, // tone freq 220,2Hz - vol 13 swept down - length 9
					0x69, // rest - length 9
					0x58]; // repeat
					
					sndtable[1] = [
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x81,0xa9,0x20,0x06,0x33,0xfc, // tone freq 661,9Hz swept up - vol 13 - length 18
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0xd5,0x20,0x1b,0x16,0x32, // tone freq 525,2Hz - vol 13 swept down - length 27
					0xa9, // rest - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x8e,0x20,0x1b,0x16,0x32, // tone freq 787,8Hz - vol 13 swept down - length 27
					0xa9, // rest - length 9
					0x82,0x71,0x20,0x09,0x16,0x14, // tone freq 989,9Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x7f,0x20,0x09,0x16,0x14, // tone freq 880,8Hz - vol 13 swept down - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0x82,0xbe,0x20,0x1b,0x16,0x32, // tone freq 588,7Hz - vol 13 swept down - length 27
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x81,0x97,0x20,0x04,0x23,0xf4, // tone freq 740,8Hz swept up - vol 13 - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x81,0xa9,0x20,0x06,0x33,0xfc, // tone freq 661,9Hz swept up - vol 13 - length 18
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0xd5,0x20,0x1b,0x16,0x32, // tone freq 525,2Hz - vol 13 swept down - length 27
					0xa9, // rest - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x8e,0x20,0x1b,0x16,0x32, // tone freq 787,8Hz - vol 13 swept down - length 27
					0xa9, // rest - length 9
					0x82,0x71,0x20,0x09,0x16,0x14, // tone freq 989,9Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x7f,0x20,0x09,0x16,0x14, // tone freq 880,8Hz - vol 13 swept down - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0x82,0xbe,0x20,0x1b,0x16,0x32, // tone freq 588,7Hz - vol 13 swept down - length 27
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x82,0x97,0x20,0x09,0x16,0x14, // tone freq 740,8Hz - vol 13 swept down - length 9
					0x81,0x97,0x20,0x04,0x23,0xf4, // tone freq 740,8Hz swept up - vol 13 - length 9
					0x82,0xa9,0x20,0x12,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 18
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x8e,0x20,0x09,0x16,0x14, // tone freq 787,8Hz - vol 13 swept down - length 9
					0x82,0x7f,0x20,0x09,0x16,0x14, // tone freq 880,8Hz - vol 13 swept down - length 9
					0x82,0x71,0x20,0x2d,0x16,0x32, // tone freq 989,9Hz - vol 13 swept down - length 45
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x81,0xa9,0x20,0x04,0x23,0xf4, // tone freq 661,9Hz swept up - vol 13 - length 9
					0x82,0x5f,0x20,0x09,0x16,0x14, // tone freq 1177,5Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x81,0xa9,0x20,0x04,0x23,0xf2, // tone freq 661,9Hz swept up - vol 13 - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x81,0xa9,0x20,0x04,0x23,0xfc, // tone freq 661,9Hz swept up - vol 13 - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0xa9,0x20,0x12, // tone freq 661,9Hz - vol 13 - length 18
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x71,0x20,0x2d, // tone freq 989,9Hz - vol 13 - length 45
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x81,0xa9,0x20,0x04,0x23,0xf4, // tone freq 661,9Hz swept up - vol 13 - length 9
					0x80,0x5f,0x20,0x09, // tone freq 1177,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x81,0xa9,0x20,0x04,0x23,0xeb, // tone freq 661,9Hz swept up - vol 13 - length 9
					0x80,0x54,0x20,0x09, // tone freq 1331,7Hz - vol 13 - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0x80,0x5f,0x20,0x09, // tone freq 1177,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x80,0xd5,0x20,0x24, // tone freq 525,2Hz - vol 13 - length 36
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x24, // tone freq 787,8Hz - vol 13 - length 36
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0xbe,0x20,0x1b, // tone freq 588,7Hz - vol 13 - length 27
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x80,0xd5,0x20,0x24, // tone freq 525,2Hz - vol 13 - length 36
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0x80,0xa9,0x20,0x09, // tone freq 661,9Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x24, // tone freq 787,8Hz - vol 13 - length 36
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0xbe,0x20,0x1b, // tone freq 588,7Hz - vol 13 - length 27
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x97,0x20,0x09, // tone freq 740,8Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x54,0x20,0x09,0x16,0x14, // tone freq 1331,7Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x5f,0x20,0x09,0x16,0x14, // tone freq 1177,5Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x6a,0x20,0x09,0x16,0x14, // tone freq 1055,3Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x71,0x20,0x09,0x16,0x14, // tone freq 989,9Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x24, // tone freq 880,8Hz - vol 13 - length 36
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x5f,0x20,0x09, // tone freq 1177,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x54,0x20,0x09, // tone freq 1331,7Hz - vol 13 - length 9
					0x81,0xa9,0x20,0x04,0x23,0x15, // tone freq 661,9Hz swept down - vol 13 - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x54,0x20,0x09,0x16,0x14, // tone freq 1331,7Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x5f,0x20,0x09,0x16,0x14, // tone freq 1177,5Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x6a,0x20,0x09,0x16,0x14, // tone freq 1055,3Hz - vol 13 swept down - length 9
					0x82,0xa9,0x20,0x09,0x16,0x14, // tone freq 661,9Hz - vol 13 swept down - length 9
					0x82,0x71,0x20,0x09,0x16,0x14, // tone freq 989,9Hz - vol 13 swept down - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x8e,0x20,0x09, // tone freq 787,8Hz - vol 13 - length 9
					0x80,0x7f,0x20,0x09, // tone freq 880,8Hz - vol 13 - length 9
					0x80,0x71,0x20,0x09, // tone freq 989,9Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x5f,0x20,0x09, // tone freq 1177,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0xa9, // rest - length 9
					0x80,0x54,0x20,0x09, // tone freq 1331,7Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x4b,0x20,0x09, // tone freq 1491,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x54,0x20,0x09, // tone freq 1331,7Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x80,0x5f,0x20,0x09, // tone freq 1177,5Hz - vol 13 - length 9
					0xa9, // rest - length 9
					0x98]; // repeat
					nbrtables = 2;
					break;
				case 11:
					// BLACKJACK POKER INTRO LOOP
					sndtable[0] = [
					   0x42,0x97,0x30,0x0c,0x1c,0x11, // tone freq 740,8Hz - vol 12 swept down - length 12
					   0x42,0x97,0x30,0x18,0x17,0x36, // tone freq 740,8Hz - vol 12 swept down - length 24
					   0x42,0xbe,0x30,0x0c,0x1c,0x11, // tone freq 588,7Hz - vol 12 swept down - length 12
					   0x42,0x97,0x30,0x24,0x1c,0x2e, // tone freq 740,8Hz - vol 12 swept down - length 36
					   0x42,0x2e,0x31,0x0c,0x1c,0x11, // tone freq 370,4Hz - vol 12 swept down - length 12
					   0x40,0xe2,0x30,0x0c, // tone freq 495,0Hz - vol 12 - length 12
					   0x42,0xbe,0x30,0x0c,0x1c,0x11, // tone freq 588,7Hz - vol 12 swept down - length 12
					   0x42,0xe2,0x30,0x0c,0x1c,0x11, // tone freq 495,0Hz - vol 12 swept down - length 12
					   0x42,0xfe,0x30,0x0c,0x1c,0x11, // tone freq 440,4Hz - vol 12 swept down - length 12
					   0x42,0x2d,0x01,0x0c,0x1c,0x11, // tone freq 371,6Hz - vol 15 (max) swept down - length 12
					   0x42,0xfe,0x00,0x24,0x1c,0x2e, // tone freq 440,4Hz - vol 15 (max) swept down - length 36
					   0x42,0x97,0x30,0x0c,0x1c,0x11, // tone freq 740,8Hz - vol 12 swept down - length 12
					   0x42,0x97,0x30,0x18,0x17,0x36, // tone freq 740,8Hz - vol 12 swept down - length 24
					   0x42,0xbe,0x30,0x0c,0x1c,0x11, // tone freq 588,7Hz - vol 12 swept down - length 12
					   0x40,0x97,0x30,0x0c, // tone freq 740,8Hz - vol 12 - length 12
					   0x42,0xbe,0x30,0x0c,0x1c,0x11, // tone freq 588,7Hz - vol 12 swept down - length 12
					   0x42,0xaa,0x30,0x0c,0x18,0x15, // tone freq 658,0Hz - vol 12 swept down - length 12
					   0x42,0xa0,0x30,0x0c,0x18,0x15, // tone freq 699,1Hz - vol 12 swept down - length 12
					   0x42,0x97,0x30,0x0c,0x18,0x15, // tone freq 740,8Hz - vol 12 swept down - length 12
					   0x42,0xbe,0x30,0x0c,0x1c,0x11, // tone freq 588,7Hz - vol 12 swept down - length 12
					   0x42,0xaa,0x30,0x0c,0x1c,0x11, // tone freq 658,0Hz - vol 12 swept down - length 12
					   0x42,0xbe,0x30,0x3c,0x1e,0x2a, // tone freq 588,7Hz - vol 12 swept down - length 60
					   0x18]; // repeat
					sndtable[1] = [
					   0x82,0xfe,0x40,0x0c,0x1c,0x11, // tone freq 440,4Hz - vol 11 swept down - length 12
					   0x82,0xbe,0x40,0x18,0x17,0x36, // tone freq 588,7Hz - vol 11 swept down - length 24
					   0x82,0x2e,0x41,0x0c,0x1c,0x11, // tone freq 370,4Hz - vol 11 swept down - length 12
					   0x82,0xfe,0x40,0x24,0x18,0x15, // tone freq 440,4Hz - vol 11 swept down - length 36
					   0x82,0xbe,0x40,0x0c,0x18,0x15, // tone freq 588,7Hz - vol 11 swept down - length 12
					   0x82,0xfe,0x40,0x0c,0x18,0x15, // tone freq 440,4Hz - vol 11 swept down - length 12
					   0x82,0x2e,0x41,0x0c,0x1c,0x11, // tone freq 370,4Hz - vol 11 swept down - length 12
					   0x82,0x1d,0x41,0x0c,0x1c,0x11, // tone freq 392,5Hz - vol 11 swept down - length 12
					   0x82,0x2e,0x41,0x3c,0x1b,0x3a, // tone freq 370,4Hz - vol 11 swept down - length 60
					   0x18]; // repeat
					sndtable[2] = [
					   0xc0,0xfa,0x22,0x0c, // tone freq 146,8Hz - vol 13 - length 12
					   0xc2,0xfc,0x51,0x0c,0x1c,0x11, // tone freq 220,2Hz - vol 10 swept down - length 12
					   0xc2,0xf8,0x23,0x0c,0x17,0x16, // tone freq 110,1Hz - vol 13 swept down - length 12
					   0xc2,0xfc,0x51,0x0c,0x1c,0x11, // tone freq 220,2Hz - vol 10 swept down - length 12
					   0xc0,0xfa,0x22,0x0c, // tone freq 146,8Hz - vol 13 - length 12
					   0xc2,0xfc,0x51,0x0c,0x1c,0x11, // tone freq 220,2Hz - vol 10 swept down - length 12
					   0xc2,0xf8,0x23,0x0c,0x17,0x16, // tone freq 110,1Hz - vol 13 swept down - length 12
					   0xc2,0xfc,0x51,0x0c,0x1c,0x11, // tone freq 220,2Hz - vol 10 swept down - length 12
					   0xc0,0xfa,0x22,0x0c, // tone freq 146,8Hz - vol 13 - length 12
					   0xc2,0xfc,0x51,0x0c,0x1c,0x11, // tone freq 220,2Hz - vol 10 swept down - length 12
					   0xc2,0xf8,0x23,0x0c,0x17,0x16, // tone freq 110,1Hz - vol 13 swept down - length 12
					   0xc2,0x5d,0x52,0x0c,0x1c,0x11, // tone freq 184,9Hz - vol 10 swept down - length 12
					   0xc0,0xfa,0x22,0x0c, // tone freq 146,8Hz - vol 13 - length 12
					   0xc2,0xf8,0x03,0x0c,0x1a,0x13, // tone freq 110,1Hz - vol 15 (max) swept down - length 12
					   0xc2,0x89,0x03,0x0c,0x1a,0x13, // tone freq 123,6Hz - vol 15 (max) swept down - length 12
					   0xc2,0x27,0x03,0x0c,0x1a,0x13, // tone freq 138,6Hz - vol 15 (max) swept down - length 12
					   0x18]; // repeat
					  nbrtables = 3;
					  break;
				
				case 12:
					// BLACKJACK POKER WAIT
					sndtable[0] = [
						0x30, // rest - length 16
						0x02,0x34,0x08,0x18,0x11, // white noise - freq 3495 Hz - vol 12 swept down - length 8
						0x18]; // repeat
					sndtable[1] = [
						0x42,0xfe,0x30,0x10,0x1a,0x17, // tone freq 440,4Hz - vol 12 swept down - length 16
						0x42,0xfe,0x20,0x18,0x1a,0x26, // tone freq 440,4Hz - vol 13 swept down - length 24
						0x42,0x2e,0x21,0x08,0x13,0x16, // tone freq 370,4Hz - vol 13 swept down - length 8
						0x42,0xfe,0x30,0x28,0x1a,0x3d, // tone freq 440,4Hz - vol 12 swept down - length 40
						0x42,0x2e,0x21,0x08,0x13,0x16, // tone freq 370,4Hz - vol 13 swept down - length 8
						0x42,0x53,0x31,0x18,0x13,0x2c, // tone freq 330,0Hz - vol 12 swept down - length 24
						0x42,0x53,0x31,0x10,0x13,0x2c, // tone freq 330,0Hz - vol 12 swept down - length 16
						0x42,0x2e,0x21,0x08,0x13,0x16, // tone freq 370,4Hz - vol 13 swept down - length 8
						0x42,0x53,0x31,0x10,0x13,0x2c, // tone freq 330,0Hz - vol 12 swept down - length 16
						0x42,0x40,0x21,0x08,0x13,0x16, // tone freq 349,6Hz - vol 13 swept down - length 8
						0x42,0x2e,0x31,0x10,0x13,0x2c, // tone freq 370,4Hz - vol 12 swept down - length 16
						0x42,0x0d,0x21,0x08,0x13,0x16, // tone freq 415,8Hz - vol 13 swept down - length 8
						0x18]; // repeat
					sndtable[2] = [
						0x82,0xca,0x50,0x18,0x16,0x26, // tone freq 553,8Hz - vol 10 swept down - length 24
						0x82,0xaa,0x50,0x10,0x16,0x26, // tone freq 658,0Hz - vol 10 swept down - length 16
						0x82,0xfe,0x40,0x08,0x16,0x13, // tone freq 440,4Hz - vol 11 swept down - length 8
						0x82,0xaa,0x50,0x10,0x16,0x26, // tone freq 658,0Hz - vol 10 swept down - length 16
						0x82,0xbe,0x40,0x08,0x16,0x13, // tone freq 588,7Hz - vol 11 swept down - length 8
						0x82,0xca,0x50,0x10,0x16,0x26, // tone freq 553,8Hz - vol 10 swept down - length 16
						0x82,0xe2,0x40,0x08,0x16,0x13, // tone freq 495,0Hz - vol 11 swept down - length 8
						0x82,0x0d,0x51,0x10,0x16,0x26, // tone freq 415,8Hz - vol 10 swept down - length 16
						0x82,0xe2,0x40,0x08,0x16,0x13, // tone freq 495,0Hz - vol 11 swept down - length 8
						0x82,0xca,0x50,0x10,0x16,0x26, // tone freq 553,8Hz - vol 10 swept down - length 16
						0x82,0xe2,0x40,0x08,0x16,0x13, // tone freq 495,0Hz - vol 11 swept down - length 8
						0x82,0x0d,0x51,0x10,0x16,0x26, // tone freq 415,8Hz - vol 10 swept down - length 16
						0x82,0xe2,0x40,0x08,0x16,0x13, // tone freq 495,0Hz - vol 11 swept down - length 8
						0x82,0xfe,0x50,0x10,0x16,0x26, // tone freq 440,4Hz - vol 10 swept down - length 16
						0x82,0xbe,0x40,0x08,0x16,0x13, // tone freq 588,7Hz - vol 11 swept down - length 8
						0x18]; // repeat
					sndtable[3] = [
						0xc2,0xf8,0x23,0x18,0x1a,0x26, // tone freq 110,1Hz - vol 13 swept down - length 24
						0xc2,0x27,0x23,0x18,0x1a,0x26, // tone freq 138,6Hz - vol 13 swept down - length 24
						0xc2,0xfa,0x22,0x18,0x1a,0x26, // tone freq 146,8Hz - vol 13 swept down - length 24
						0xc2,0xcd,0x22,0x18,0x1a,0x26, // tone freq 156,0Hz - vol 13 swept down - length 24
						0xc2,0xa7,0x22,0x18,0x1a,0x26, // tone freq 164,7Hz - vol 13 swept down - length 24
						0xc2,0xfa,0x22,0x18,0x1a,0x26, // tone freq 146,8Hz - vol 13 swept down - length 24
						0xc2,0x27,0x23,0x18,0x1a,0x26, // tone freq 138,6Hz - vol 13 swept down - length 24
						0xc2,0x89,0x23,0x18,0x1a,0x26, // tone freq 123,6Hz - vol 13 swept down - length 24
						0x18]; // repeat
					nbrtables = 4;
					break;
				case 13:
					// BURGER TIME
					sndtable[0] = [
						0x40,0xaa,0x50,0x03, // tone freq 658,0Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0xaa,0x50,0x03, // tone freq 658,0Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0xa0,0x50,0x03, // tone freq 699,1Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0xa0,0x50,0x03, // tone freq 699,1Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x97,0x50,0x03, // tone freq 740,8Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x97,0x50,0x03, // tone freq 740,8Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x87,0x50,0x03, // tone freq 828,6Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x87,0x50,0x03, // tone freq 828,6Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x7f,0x50,0x09, // tone freq 880,8Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0xaa,0x50,0x09, // tone freq 658,0Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0x7f,0x50,0x09, // tone freq 880,8Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0xaa,0x50,0x09, // tone freq 658,0Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x03, // tone freq 782,2Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x6b,0x50,0x03, // tone freq 1045,4Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x71,0x50,0x03, // tone freq 989,9Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x7f,0x50,0x03, // tone freq 880,8Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x03, // tone freq 782,2Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x97,0x50,0x03, // tone freq 740,8Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x03, // tone freq 782,2Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x97,0x50,0x03, // tone freq 740,8Hz - vol 10 - length 3
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x09, // tone freq 782,2Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0x6b,0x50,0x09, // tone freq 1045,4Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x09, // tone freq 782,2Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0x6b,0x50,0x09, // tone freq 1045,4Hz - vol 10 - length 9
						0x63, // rest - length 3
						0x40,0x8f,0x50,0x08, // tone freq 782,2Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x55,0x50,0x0a, // tone freq 1316,0Hz - vol 10 - length 10
						0x62, // rest - length 2
						0x40,0x8f,0x50,0x08, // tone freq 782,2Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x55,0x50,0x08, // tone freq 1316,0Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x7f,0x50,0x08, // tone freq 880,8Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x5f,0x50,0x08, // tone freq 1177,5Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x8f,0x50,0x08, // tone freq 782,2Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x6b,0x50,0x08, // tone freq 1045,4Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x7f,0x50,0x08, // tone freq 880,8Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x5f,0x50,0x08, // tone freq 1177,5Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x8f,0x50,0x08, // tone freq 782,2Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x40,0x6b,0x50,0x08, // tone freq 1045,4Hz - vol 10 - length 8
						0x64, // rest - length 4
						0x58]; // repeat
					sndtable[1] = [
						0x80,0x40,0x61,0x03, // tone freq 349,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x40,0x61,0x03, // tone freq 349,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x53,0x61,0x03, // tone freq 330,0Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x53,0x61,0x03, // tone freq 330,0Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x68,0x61,0x03, // tone freq 310,7Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x68,0x61,0x03, // tone freq 310,7Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x7d,0x61,0x03, // tone freq 293,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x7d,0x61,0x03, // tone freq 293,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x94,0x61,0x0f, // tone freq 276,9Hz - vol 9 - length 15
						0xa3, // rest - length 3
						0x80,0x94,0x61,0x03, // tone freq 276,9Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x94,0x61,0x15, // tone freq 276,9Hz - vol 9 - length 21
						0xa3, // rest - length 3
						0xa3, // rest - length 3
						0x80,0xac,0x61,0x03, // tone freq 261,4Hz - vol 9 - length 3
						0xa9, // rest - length 9
						0x80,0x7d,0x61,0x03, // tone freq 293,6Hz - vol 9 - length 3
						0xa9, // rest - length 9
						0x80,0x53,0x61,0x03, // tone freq 330,0Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x7d,0x61,0x03, // tone freq 293,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x53,0x61,0x03, // tone freq 330,0Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x7d,0x61,0x03, // tone freq 293,6Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x53,0x61,0x06, // tone freq 330,0Hz - vol 9 - length 6
						0xac, // rest - length 12
						0x80,0x53,0x61,0x03, // tone freq 330,0Hz - vol 9 - length 3
						0xa3, // rest - length 3
						0x80,0x53,0x61,0x06, // tone freq 330,0Hz - vol 9 - length 6
						0xb2, // rest - length 18
						0x80,0xac,0x61,0x08, // tone freq 261,4Hz - vol 9 - length 8
						0xaa, // rest - length 10
						0x80,0xac,0x61,0x04, // tone freq 261,4Hz - vol 9 - length 4
						0xa2, // rest - length 2
						0x80,0xac,0x61,0x08, // tone freq 261,4Hz - vol 9 - length 8
						0xb0, // rest - length 16
						0x80,0x7d,0x61,0x08, // tone freq 293,6Hz - vol 9 - length 8
						0xb0, // rest - length 16
						0x80,0xac,0x61,0x08, // tone freq 261,4Hz - vol 9 - length 8
						0xb0, // rest - length 16
						0x80,0x7d,0x61,0x08, // tone freq 293,6Hz - vol 9 - length 8
						0xb0, // rest - length 16
						0x80,0xac,0x61,0x08, // tone freq 261,4Hz - vol 9 - length 8
						0xb0, // rest - length 16
						0x98]; // repeat
					nbrtables = 2;
					break;
				case 14:
					// Omega Race Intro
					sndtable[0] = [
						0x42,0x47,0x00,0x63,0x16,0x11, // tone freq 1575,5Hz - vol 15 (max) swept down - length 99
						0x42,0x47,0x60,0x2c,0xf6,0x68, // tone freq 1575,5Hz - vol 9 swept up - length 44
						0x41,0x43,0x10,0x02,0xbb,0x04, // tone freq 1669,6Hz swept down - vol 14 - length 22
						0x41,0x55,0x10,0x02,0xbb,0x10, // tone freq 1316,0Hz swept down - vol 14 - length 22
						0x41,0x5f,0x20,0x02,0xbb,0x06, // tone freq 1177,5Hz swept down - vol 13 - length 22
						0x41,0x7f,0x20,0x02,0xbb,0x21, // tone freq 880,8Hz swept down - vol 13 - length 22
						0x41,0xca,0x30,0x02,0xbb,0x43, // tone freq 553,8Hz swept down - vol 12 - length 22
						0x41,0xfc,0x41,0x02,0xbb,0x1f, // tone freq 220,2Hz swept down - vol 11 - length 22
						0x41,0xca,0x32,0x02,0xbb,0x30, // tone freq 156,7Hz swept down - vol 12 - length 22
						0x41,0x27,0x23,0x02,0xbb,0x30, // tone freq 138,6Hz swept down - vol 13 - length 22
						0x40,0xbf,0x13,0x0b, // tone freq 116,6Hz - vol 14 - length 11
						0x50]; // end
					sndtable[1] = [
						0xf6, // rest - length 22
						0xf6, // rest - length 22
						0xc2,0x5a,0x00,0x37,0x16,0x11, // tone freq 1242,9Hz - vol 15 (max) swept down - length 55
						0xc2,0x5a,0x60,0x2c,0xf6,0x68, // tone freq 1242,9Hz - vol 9 swept up - length 44
						0xc1,0x55,0x10,0x02,0xbb,0x05, // tone freq 1316,0Hz swept down - vol 14 - length 22
						0xc1,0x6b,0x10,0x02,0xbb,0x0c, // tone freq 1045,4Hz swept down - vol 14 - length 22
						0xc1,0x78,0x20,0x02,0xbb,0x07, // tone freq 932,2Hz swept down - vol 13 - length 22
						0xc1,0x97,0x30,0x02,0xbb,0xe1, // tone freq 740,8Hz swept up - vol 12 - length 22
						0xc1,0x71,0x40,0x04,0xbb,0xfa, // tone freq 989,9Hz swept up - vol 11 - length 44
						0xc1,0x5a,0x30,0x03,0xbb,0xfb, // tone freq 1242,9Hz swept up - vol 12 - length 33
						0xc1,0x47,0x20,0x02,0xbb,0xfc, // tone freq 1575,5Hz swept up - vol 13 - length 22
						0xc2,0x40,0x10,0xb0,0x1e,0xc8, // tone freq 1747,8Hz - vol 14 swept down - length 176
						0xd0]; // end
					sndtable[2] = [
						0xbc, // rest - length 28
						0xbe, // rest - length 30
						0xbe, // rest - length 30
						0x82,0x71,0x00,0x0b,0x16,0x11, // tone freq 989,9Hz - vol 15 (max) swept down - length 11
						0x82,0x71,0x60,0x2c,0xf6,0x68, // tone freq 989,9Hz - vol 9 swept up - length 44
						0x81,0x6b,0x10,0x02,0xbb,0x06, // tone freq 1045,4Hz swept down - vol 14 - length 22
						0x81,0x87,0x10,0x02,0xbb,0x08, // tone freq 828,6Hz swept down - vol 14 - length 22
						0x81,0xa0,0x20,0x02,0xbb,0x0a, // tone freq 699,1Hz swept down - vol 13 - length 22
						0x81,0xb4,0x20,0x02,0xbb,0x22, // tone freq 621,4Hz swept down - vol 13 - length 22
						0x81,0x97,0x40,0x02,0xbb,0x09, // tone freq 740,8Hz swept down - vol 11 - length 22
						0x81,0xaa,0x30,0x02,0xbb,0x38, // tone freq 658,0Hz swept down - vol 12 - length 22
						0x81,0xd6,0x20,0x02,0xbb,0xe8, // tone freq 522,7Hz swept up - vol 13 - length 22
						0x81,0xca,0x10,0x02,0xbb,0xf4, // tone freq 553,8Hz swept up - vol 14 - length 22
						0x82,0xab,0x00,0xbb,0x1e,0xd5, // tone freq 654,2Hz - vol 15 (max) swept down - length 187
						0x90]; // end
					nbrtables = 3;
					break;
				case 15:
					// Pepper II
					sndtable[0] = [
						0x41,0xa7,0x42,0x07,0x14,0x37, // tone freq 164,7Hz swept down - vol 11 - length 10
						0x42,0xf8,0x43,0x14,0x33,0x16, // tone freq 110,1Hz - vol 11 swept down - length 20
						0x41,0xfe,0x40,0x02,0x37,0xe4, // tone freq 440,4Hz swept up - vol 11 - length 10
						0x42,0xfe,0x40,0x0a,0x33,0x16, // tone freq 440,4Hz - vol 11 swept down - length 10
						0x42,0x0d,0x41,0x0a,0x33,0x16, // tone freq 415,8Hz - vol 11 swept down - length 10
						0x42,0x2e,0x41,0x0a,0x33,0x16, // tone freq 370,4Hz - vol 11 swept down - length 10
						0x42,0x0d,0x41,0x14,0x33,0x16, // tone freq 415,8Hz - vol 11 swept down - length 20
						0x42,0xfe,0x40,0x0a,0x33,0x16, // tone freq 440,4Hz - vol 11 swept down - length 10
						0x42,0xe2,0x40,0x14,0x33,0x16, // tone freq 495,0Hz - vol 11 swept down - length 20
						0x41,0xa7,0x42,0x07,0x14,0x37, // tone freq 164,7Hz swept down - vol 11 - length 10
						0x42,0xf8,0x43,0x14,0x33,0x16, // tone freq 110,1Hz - vol 11 swept down - length 20
						0x41,0xfe,0x40,0x02,0x37,0xe4, // tone freq 440,4Hz swept up - vol 11 - length 10
						0x42,0xfe,0x40,0x0a,0x33,0x16, // tone freq 440,4Hz - vol 11 swept down - length 10
						0x42,0x0d,0x41,0x0a,0x33,0x16, // tone freq 415,8Hz - vol 11 swept down - length 10
						0x42,0x2e,0x41,0x0a,0x33,0x16, // tone freq 370,4Hz - vol 11 swept down - length 10
						0x42,0x0d,0x41,0x14,0x33,0x16, // tone freq 415,8Hz - vol 11 swept down - length 20
						0x42,0xfe,0x40,0x0a,0x33,0x16, // tone freq 440,4Hz - vol 11 swept down - length 10
						0x42,0xe2,0x40,0x14,0x33,0x16, // tone freq 495,0Hz - vol 11 swept down - length 20
						0x41,0xa7,0x42,0x07,0x14,0x37, // tone freq 164,7Hz swept down - vol 11 - length 10
						0x42,0xf8,0x43,0x14,0x33,0x16, // tone freq 110,1Hz - vol 11 swept down - length 20
						0x40,0xac,0x41,0x0a, // tone freq 261,4Hz - vol 11 - length 10
						0x40,0x53,0x41,0x14, // tone freq 330,0Hz - vol 11 - length 20
						0x40,0x7d,0x41,0x0a, // tone freq 293,6Hz - vol 11 - length 10
						0x42,0xac,0x41,0x14,0x33,0x16, // tone freq 261,4Hz - vol 11 swept down - length 20
						0x40,0x53,0x41,0x0a, // tone freq 330,0Hz - vol 11 - length 10
						0x40,0x1d,0x41,0x14, // tone freq 392,5Hz - vol 11 - length 20
						0x40,0x40,0x41,0x0a, // tone freq 349,6Hz - vol 11 - length 10
						0x42,0x53,0x41,0x14,0x33,0x16, // tone freq 330,0Hz - vol 11 swept down - length 20
						0x40,0x1d,0x41,0x0a, // tone freq 392,5Hz - vol 11 - length 10
						0x40,0xe2,0x40,0x14, // tone freq 495,0Hz - vol 11 - length 20
						0x40,0xfe,0x40,0x0a, // tone freq 440,4Hz - vol 11 - length 10
						0x42,0x0d,0x41,0x0a,0x33,0x16, // tone freq 415,8Hz - vol 11 swept down - length 10
						0x42,0x81,0x52,0x0a,0x33,0x16, // tone freq 174,5Hz - vol 10 swept down - length 10
						0x42,0xa7,0x62,0x0a,0x33,0x16, // tone freq 164,7Hz - vol 9 swept down - length 10
						0x42,0xfa,0x72,0x0a,0x33,0x16, // tone freq 146,8Hz - vol 8 swept down - length 10
						0x42,0x89,0x83,0x0a,0x33,0x16, // tone freq 123,6Hz - vol 7 swept down - length 10
						0x40,0xa7,0x52,0x04, // tone freq 164,7Hz - vol 10 - length 4
						0x58]; // repeat
					sndtable[1] = [
						0x80,0xac,0xf1,0x28, // rest - length 40
						0x80,0xac,0x71,0x1e, // tone freq 261,4Hz - vol 8 - length 30
						0x80,0x53,0x71,0x1e, // tone freq 330,0Hz - vol 8 - length 30
						0x82,0x53,0x71,0x3c,0x18,0x96, // tone freq 330,0Hz - vol 8 swept down - length 60
						0x80,0xac,0x71,0x1e, // tone freq 261,4Hz - vol 8 - length 30
						0x80,0x53,0x71,0x1e, // tone freq 330,0Hz - vol 8 - length 30
						0x82,0x53,0x71,0x1e,0x18,0x96, // tone freq 330,0Hz - vol 8 swept down - length 30
						0x80,0x53,0xf1,0x14, // rest - length 20
						0x80,0xfc,0x71,0x0a, // tone freq 220,2Hz - vol 8 - length 10
						0x80,0x1b,0x72,0x14, // tone freq 207,5Hz - vol 8 - length 20
						0x80,0xc5,0x71,0x0a, // tone freq 246,9Hz - vol 8 - length 10
						0x82,0xfc,0x71,0x14,0x33,0x96, // tone freq 220,2Hz - vol 8 swept down - length 20
						0x80,0xac,0x71,0x0a, // tone freq 261,4Hz - vol 8 - length 10
						0x80,0xc5,0x71,0x14, // tone freq 246,9Hz - vol 8 - length 20
						0x80,0x7d,0x71,0x0a, // tone freq 293,6Hz - vol 8 - length 10
						0x82,0xac,0x71,0x14,0x33,0x96, // tone freq 261,4Hz - vol 8 swept down - length 20
						0x80,0x53,0x71,0x0a, // tone freq 330,0Hz - vol 8 - length 10
						0x80,0x68,0x71,0x14, // tone freq 310,7Hz - vol 8 - length 20
						0x80,0x2e,0x71,0x0a, // tone freq 370,4Hz - vol 8 - length 10
						0x82,0x53,0x71,0x36,0x33,0x96, // tone freq 330,0Hz - vol 8 swept down - length 54
						0x98]; // repeat
					nbrtables = 2;
					break;
				case 16:
					// SPY HUNTER
					sndtable[0] = [
						0x40,0x00,0xf0,0xd0, // rest - length 208
						0x40,0x1d,0xe1,0x06, // tone freq 392,5Hz - vol 1 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0xd1,0x05, // tone freq 392,5Hz - vol 2 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xc1,0x06, // tone freq 392,5Hz - vol 3 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0xb1,0x05, // tone freq 392,5Hz - vol 4 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xa1,0x06, // tone freq 392,5Hz - vol 5 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x91,0x05, // tone freq 392,5Hz - vol 6 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x81,0x06, // tone freq 392,5Hz - vol 7 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x71,0x05, // tone freq 392,5Hz - vol 8 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x61,0x06, // tone freq 392,5Hz - vol 9 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x51,0x05, // tone freq 392,5Hz - vol 10 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x41,0x06, // tone freq 392,5Hz - vol 11 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x31,0x05, // tone freq 392,5Hz - vol 12 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x21,0x06, // tone freq 392,5Hz - vol 13 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x11,0x05, // tone freq 392,5Hz - vol 14 - length 5
						0x61, // rest - length 1
						0x67, // rest - length 7
						0x40,0x53,0x21,0x05, // tone freq 330,0Hz - vol 13 - length 5
						0x61, // rest - length 1
						0x40,0x53,0x21,0x06, // tone freq 330,0Hz - vol 13 - length 6
						0x61, // rest - length 1
						0x40,0x53,0x31,0x05, // tone freq 330,0Hz - vol 12 - length 5
						0x61, // rest - length 1
						0x40,0x53,0x31,0x06, // tone freq 330,0Hz - vol 12 - length 6
						0x61, // rest - length 1
						0x40,0x53,0x41,0x05, // tone freq 330,0Hz - vol 11 - length 5
						0x61, // rest - length 1
						0x40,0x53,0x51,0x06, // tone freq 330,0Hz - vol 10 - length 6
						0x61, // rest - length 1
						0x40,0x53,0x61,0x05, // tone freq 330,0Hz - vol 9 - length 5
						0x61, // rest - length 1
						0x40,0x53,0x71,0x06, // tone freq 330,0Hz - vol 8 - length 6
						0x61, // rest - length 1
						0x40,0x53,0x81,0x05, // tone freq 330,0Hz - vol 7 - length 5
						0x61, // rest - length 1
						0x40,0x53,0x91,0x06, // tone freq 330,0Hz - vol 6 - length 6
						0x61, // rest - length 1
						0x40,0x53,0xa1,0x05, // tone freq 330,0Hz - vol 5 - length 5
						0x61, // rest - length 1
						0x40,0x53,0xb1,0x06, // tone freq 330,0Hz - vol 4 - length 6
						0x61, // rest - length 1
						0x40,0x53,0xc1,0x05, // tone freq 330,0Hz - vol 3 - length 5
						0x61, // rest - length 1
						0x40,0x53,0xd1,0x06, // tone freq 330,0Hz - vol 2 - length 6
						0x61, // rest - length 1
						0x40,0x53,0xd1,0x05, // tone freq 330,0Hz - vol 2 - length 5
						0x61, // rest - length 1
						0x40,0x53,0xe1,0x06, // tone freq 330,0Hz - vol 1 - length 6
						0x61, // rest - length 1
						0x40,0x53,0xe1,0x05, // tone freq 330,0Hz - vol 1 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xe1,0x06, // tone freq 392,5Hz - vol 1 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0xd1,0x05, // tone freq 392,5Hz - vol 2 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xd1,0x06, // tone freq 392,5Hz - vol 2 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0xc1,0x05, // tone freq 392,5Hz - vol 3 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xc1,0x06, // tone freq 392,5Hz - vol 3 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0xb1,0x05, // tone freq 392,5Hz - vol 4 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0xa1,0x06, // tone freq 392,5Hz - vol 5 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x91,0x05, // tone freq 392,5Hz - vol 6 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x81,0x06, // tone freq 392,5Hz - vol 7 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x71,0x05, // tone freq 392,5Hz - vol 8 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x61,0x06, // tone freq 392,5Hz - vol 9 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x51,0x05, // tone freq 392,5Hz - vol 10 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x41,0x06, // tone freq 392,5Hz - vol 11 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x31,0x05, // tone freq 392,5Hz - vol 12 - length 5
						0x61, // rest - length 1
						0x40,0x1d,0x21,0x06, // tone freq 392,5Hz - vol 13 - length 6
						0x61, // rest - length 1
						0x40,0x1d,0x21,0x05, // tone freq 392,5Hz - vol 13 - length 5
						0x61, // rest - length 1
						0x42,0xaa,0x20,0x0d,0x16,0x17, // tone freq 658,0Hz - vol 13 swept down - length 13
						0x40,0xf0,0x20,0x1a, // tone freq 466,1Hz - vol 13 - length 26
						0x43,0xf0,0x30,0x0b,0x65,0x10,0x1c,0x55, // tone freq 466,1Hz swept down - vol 12 swept down - length 65
						0x6d, // rest - length 13
						0x42,0x53,0x21,0x0d,0x16,0x17, // tone freq 330,0Hz - vol 13 swept down - length 13
						0x42,0x1d,0x21,0x0d,0x16,0x17, // tone freq 392,5Hz - vol 13 swept down - length 13
						0x42,0xfe,0x20,0x0b,0x16,0x15, // tone freq 440,4Hz - vol 13 swept down - length 11
						0x40,0xfe,0x20,0x02, // tone freq 440,4Hz - vol 13 - length 2
						0x42,0xf0,0x20,0x12,0x16,0x1c, // tone freq 466,1Hz - vol 13 swept down - length 18
						0x42,0xf0,0x30,0x11,0x16,0x1b, // tone freq 466,1Hz - vol 12 swept down - length 17
						0x42,0xf0,0x20,0x11,0x16,0x1b, // tone freq 466,1Hz - vol 13 swept down - length 17
						0x42,0xf0,0x20,0x12,0x16,0x1c, // tone freq 466,1Hz - vol 13 swept down - length 18
						0x42,0xfe,0x20,0x11,0x16,0x1b, // tone freq 440,4Hz - vol 13 swept down - length 17
						0x42,0x1d,0x21,0x0f,0x16,0x19, // tone freq 392,5Hz - vol 13 swept down - length 15
						0x40,0x68,0x21,0x02, // tone freq 310,7Hz - vol 13 - length 2
						0x42,0x53,0x21,0x12,0x16,0x1c, // tone freq 330,0Hz - vol 13 swept down - length 18
						0x42,0x7d,0x21,0x11,0x16,0x1b, // tone freq 293,6Hz - vol 13 swept down - length 17
						0x42,0x53,0x21,0x0f,0x16,0x19, // tone freq 330,0Hz - vol 13 swept down - length 15
						0x41,0xc5,0x21,0x02,0xd2,0xe7, // tone freq 246,9Hz swept up - vol 13 - length 15
						0x42, 0x94, 0x21, 0x5b, 0x1d, 0x6d, // tone freq 276,9Hz - vol 13 swept down - length 91
						////
						0x40,0x00,0xf0,0x99, // rest - length 153
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x41,0x0d,0x51,0x02,0xe3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 17
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x42,0xfd,0x50,0x6a,0x1b,0x97, // tone freq 442,1Hz - vol 10 swept down - length 106
						0x41,0x1d,0x51,0x02,0x67,0xe1, // tone freq 392,5Hz swept up - vol 10 - length 13
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x42,0x53,0x51,0x06,0x23,0x13, // tone freq 330,0Hz - vol 10 swept down - length 6
						0x42,0x1d,0x51,0x0d,0x17,0x16, // tone freq 392,5Hz - vol 10 swept down - length 13
						0x42,0xfd,0x50,0x72,0x1b,0x5a, // tone freq 442,1Hz - vol 10 swept down - length 114
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x41,0x0d,0x51,0x02,0xe3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 17
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x42,0xfd,0x50,0x6a,0x1b,0x97, // tone freq 442,1Hz - vol 10 swept down - length 106
						0x41,0x1d,0x51,0x02,0x67,0xe1, // tone freq 392,5Hz swept up - vol 10 - length 13
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x42,0x53,0x51,0x06,0x23,0x13, // tone freq 330,0Hz - vol 10 swept down - length 6
						0x41,0x1d,0x51,0x02,0x67,0xe1, // tone freq 392,5Hz swept up - vol 10 - length 13
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x42,0x53,0x51,0x06,0x23,0x13, // tone freq 330,0Hz - vol 10 swept down - length 6
						0x41,0x68,0x51,0x02,0x67,0x15, // tone freq 310,7Hz swept down - vol 10 - length 13
						0x42,0xac,0x51,0x07,0x14,0x13, // tone freq 261,4Hz - vol 10 swept down - length 7
						0x42,0xfc,0x51,0x06,0x23,0x13, // tone freq 220,2Hz - vol 10 swept down - length 6
						0x41,0x3b,0x52,0x02,0x67,0x6c, // tone freq 195,9Hz swept down - vol 10 - length 13
						0x42,0x3b,0x52,0x07,0x14,0x13, // tone freq 195,9Hz - vol 10 swept down - length 7
						0x42,0xfc,0x51,0x06,0x23,0x13, // tone freq 220,2Hz - vol 10 swept down - length 6
						0x41,0xac,0x51,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 10 - length 13
						0x41,0xac,0x51,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 10 - length 13
						0x41,0xac,0x51,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 10 - length 13
						0x41,0xac,0x61,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 9 - length 13
						0x41,0xac,0x71,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 8 - length 13
						0x41,0xac,0x81,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 7 - length 13
						0x41,0xac,0x91,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 6 - length 13
						0x41,0xac,0xa1,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 5 - length 13
						0x41,0xac,0xb1,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 4 - length 13
						0x41,0xac,0xc1,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 3 - length 13
						0x41,0xac,0xd1,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 2 - length 13
						0x41,0xac,0xd1,0x02,0x67,0xe8, // tone freq 261,4Hz swept up - vol 2 - length 13
						0x41,0xac,0xd1,0x02,0x67,0x19, // tone freq 261,4Hz swept down - vol 2 - length 13
						0x41,0xe0,0xd1,0x02,0x67,0x1c, // tone freq 233,0Hz swept down - vol 2 - length 13
						0x41,0x1b,0xe2,0x02,0x67,0x20, // tone freq 207,5Hz swept down - vol 1 - length 13
						0x41,0x5d,0xe2,0x02,0x67,0x24, // tone freq 184,9Hz swept down - vol 1 - length 13
						0x7e, // rest - length 30
						0x73, // rest - length 19
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x41,0x0d,0x51,0x02,0xe3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 17
						0x41,0x0d,0x51,0x02,0xf3,0xf0, // tone freq 415,8Hz swept up - vol 10 - length 18
						0x42,0xfd,0x50,0x6a,0x1b,0x97, // tone freq 442,1Hz - vol 10 swept down - length 106
						0x41,0x1d,0x51,0x02,0x67,0xe1, // tone freq 392,5Hz swept up - vol 10 - length 13
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x42,0x53,0x51,0x06,0x23,0x13, // tone freq 330,0Hz - vol 10 swept down - length 6
						0x41,0x1d,0x51,0x02,0x67,0xe1, // tone freq 392,5Hz swept up - vol 10 - length 13
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x42,0x53,0x51,0x06,0x23,0x13, // tone freq 330,0Hz - vol 10 swept down - length 6
						0x41,0x68,0x51,0x02,0x67,0x15, // tone freq 310,7Hz swept down - vol 10 - length 13
						0x42,0xac,0x51,0x07,0x14,0x13, // tone freq 261,4Hz - vol 10 swept down - length 7
						0x42,0xfc,0x51,0x06,0x23,0x13, // tone freq 220,2Hz - vol 10 swept down - length 6
						0x42,0x1d,0x51,0x07,0x14,0x13, // tone freq 392,5Hz - vol 10 swept down - length 7
						0x41,0x53,0x51,0x02,0x76,0x15, // tone freq 330,0Hz swept down - vol 10 - length 13
						0x42,0x7d,0x51,0x06,0x23,0x13, // tone freq 293,6Hz - vol 10 swept down - length 6
						0x41,0xac,0x51,0x02,0x67,0x50, // tone freq 261,4Hz swept down - vol 10 - length 13
						0x42,0x3b,0x52,0x07,0x14,0x13, // tone freq 195,9Hz - vol 10 swept down - length 7
						0x42,0xa7,0x52,0x06,0x23,0x13, // tone freq 164,7Hz - vol 10 swept down - length 6
						0x41,0x3b,0x52,0x02,0x67,0xc1, // tone freq 195,9Hz swept up - vol 10 - length 13
						0x42,0xa7,0x52,0x07,0x14,0x13, // tone freq 164,7Hz - vol 10 swept down - length 7
						0x42,0x68,0x51,0x06,0x23,0x13, // tone freq 310,7Hz - vol 10 swept down - length 6
						0x41,0x7d,0x51,0x02,0x67,0x2f, // tone freq 293,6Hz swept down - vol 10 - length 13
						0x42,0xfc,0x51,0x07,0x14,0x13, // tone freq 220,2Hz - vol 10 swept down - length 7
						0x42,0xd6,0x50,0x06,0x23,0x13, // tone freq 522,7Hz - vol 10 swept down - length 6
						0x41,0xfd,0x50,0x02,0x67,0x1f, // tone freq 442,1Hz swept down - vol 10 - length 13
						0x42,0x53,0x51,0x07,0x14,0x13, // tone freq 330,0Hz - vol 10 swept down - length 7
						0x42,0x68,0x51,0x06,0x23,0x13, // tone freq 310,7Hz - vol 10 swept down - length 6
						0x41,0x7d,0x51,0x02,0x67,0x2f, // tone freq 293,6Hz swept down - vol 10 - length 13
						0x42,0xfc,0x51,0x07,0x14,0x13, // tone freq 220,2Hz - vol 10 swept down - length 7
						0x42,0x3b,0x52,0x06,0x23,0x13, // tone freq 195,9Hz - vol 10 swept down - length 6
						0x41,0xbe,0x50,0x02,0x67,0x18, // tone freq 588,7Hz swept down - vol 10 - length 13
						0x42,0xfd,0x50,0x07,0x14,0x13, // tone freq 442,1Hz - vol 10 swept down - length 7
						0x42,0x1d,0x51,0x06,0x23,0x13, // tone freq 392,5Hz - vol 10 swept down - length 6
						0x41,0xb4,0x50,0x02,0x34,0x0a, // tone freq 621,4Hz swept down - vol 10 - length 7
						0x41,0xca,0x50,0x02,0x33,0x0c, // tone freq 553,8Hz swept down - vol 10 - length 6
						0x41,0xfd,0x50,0x02,0x34,0x82, // tone freq 442,1Hz swept up - vol 10 - length 7
						0x41,0x8f,0x50,0x02,0x33,0x1b, // tone freq 782,2Hz swept down - vol 10 - length 6
						0x41,0xb4,0x50,0x02,0x34,0x0a, // tone freq 621,4Hz swept down - vol 10 - length 7
						0x41,0xd6,0x50,0x02,0x33,0x28, // tone freq 522,7Hz swept down - vol 10 - length 6
						0x41,0x1d,0x51,0x02,0x34,0x36, // tone freq 392,5Hz swept down - vol 10 - length 7
						0x41,0x1d,0x51,0x02,0x33,0xe0, // tone freq 392,5Hz swept up - vol 10 - length 6
						0x41,0xaa,0x50,0x02,0x34,0x0a, // tone freq 658,0Hz swept down - vol 10 - length 7
						0x41,0xbe,0x50,0x02,0x33,0x18, // tone freq 588,7Hz swept down - vol 10 - length 6
						0x40,0xfd,0x50,0x04, // tone freq 442,1Hz - vol 10 - length 4
						0x40,0x6b,0x50,0x03, // tone freq 1045,4Hz - vol 10 - length 3
						0x41,0x5f,0x50,0x02,0x33,0x0c, // tone freq 1177,5Hz swept down - vol 10 - length 6
						0x41,0x7f,0x50,0x02,0x34,0x10, // tone freq 880,8Hz swept down - vol 10 - length 7
						0x41,0xaa,0x50,0x02,0x33,0x0b, // tone freq 658,0Hz swept down - vol 10 - length 6
						0x41,0xbe,0x50,0x02,0x34,0x18, // tone freq 588,7Hz swept down - vol 10 - length 7
						0x41,0xfd,0x50,0x02,0x33,0x55, // tone freq 442,1Hz swept down - vol 10 - length 6
						0x41,0x1d,0x51,0x02,0x34,0x36, // tone freq 392,5Hz swept down - vol 10 - length 7
						0x41,0x68,0x51,0x02,0x33,0x15, // tone freq 310,7Hz swept down - vol 10 - length 6
						0x41,0xac,0x51,0x02,0x34,0x50, // tone freq 261,4Hz swept down - vol 10 - length 7
						0x41,0x3b,0x52,0x02,0x33,0x6c, // tone freq 195,9Hz swept down - vol 10 - length 6
						0x41,0x3b,0x52,0x02,0x34,0xc1, // tone freq 195,9Hz swept up - vol 10 - length 7
						0x41,0x3b,0x52,0x02,0x33,0x6c, // tone freq 195,9Hz swept down - vol 10 - length 6
						0x40,0xfa,0x52,0x04, // tone freq 146,8Hz - vol 10 - length 4
						0x40,0x57,0x53,0x03, // tone freq 130,8Hz - vol 10 - length 3
						0x42,0xf8,0x53,0xfa,0x1b,0x95, // tone freq 110,1Hz - vol 10 swept down - length 250
						0x40,0x00,0xf0,0xe0, // rest - length 224
						0x42,0xfd,0xe0,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 1 swept up - length 7
						0x42,0xfd,0xd0,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 2 swept up - length 6
						0x42,0xfd,0xc0,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 3 swept up - length 7
						0x42,0xfd,0xb0,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 4 swept up - length 6
						0x42,0xfd,0xa0,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 5 swept up - length 7
						0x42,0xfd,0x90,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 6 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xfd,0x70,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 8 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x73, // rest - length 19
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x6d, // rest - length 13
						0x42,0xfd,0x80,0x0d,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 13
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x0d,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 13
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0x55,0x80,0x06,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0x55,0x80,0x06,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0x8f,0x80,0x06,0xf4,0x11, // tone freq 782,2Hz - vol 7 swept up - length 6
						0x42,0x5a,0x80,0x07,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 7
						0x42,0x7f,0x80,0x06,0xf4,0x11, // tone freq 880,8Hz - vol 7 swept up - length 6
						0x42,0x5a,0x80,0x07,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 7
						0x42,0x5a,0x80,0x06,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 6
						0x42,0x5a,0x80,0x07,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 7
						0x42,0x55,0x80,0x06,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x42,0x55,0x80,0x06,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x42,0x55,0x80,0x06,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 6
						0x41,0xaa,0x50,0x02,0x34,0x54, // tone freq 658,0Hz swept down - vol 10 - length 7
						0x41,0xd6,0x50,0x02,0x33,0xe8, // tone freq 522,7Hz swept up - vol 10 - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0xaa,0x80,0x07,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 7
						0x66, // rest - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x14,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 20
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xfd,0x80,0x07,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xbe,0x80,0x07,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0x8f,0x80,0x07,0xf4,0x11, // tone freq 782,2Hz - vol 7 swept up - length 7
						0x42,0x5a,0x80,0x06,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 6
						0x42,0x8f,0x80,0x07,0xf4,0x11, // tone freq 782,2Hz - vol 7 swept up - length 7
						0x42,0x5a,0x80,0x06,0xf4,0x11, // tone freq 1242,9Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0x8f,0x80,0x06,0xf4,0x11, // tone freq 782,2Hz - vol 7 swept up - length 6
						0x41,0x55,0x50,0x02,0x34,0x3a, // tone freq 1316,0Hz swept down - vol 10 - length 7
						0x42,0x7f,0x80,0x06,0xf4,0x11, // tone freq 880,8Hz - vol 7 swept up - length 6
						0x42,0x6b,0x80,0x07,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 7
						0x42,0x6b,0x80,0x06,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 6
						0x42,0x6b,0x80,0x07,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 7
						0x42,0x71,0x80,0x06,0xf4,0x11, // tone freq 989,9Hz - vol 7 swept up - length 6
						0x42,0x6b,0x80,0x07,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 7
						0x42,0x6b,0x80,0x06,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 6
						0x42,0x6b,0x80,0x07,0xf4,0x11, // tone freq 1045,4Hz - vol 7 swept up - length 7
						0x42,0x5f,0x80,0x06,0xf4,0x11, // tone freq 1177,5Hz - vol 7 swept up - length 6
						0x42,0x55,0x80,0x07,0xf4,0x11, // tone freq 1316,0Hz - vol 7 swept up - length 7
						0x42,0x47,0x80,0x06,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x80,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 6
						0x67, // rest - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x6d, // rest - length 13
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xb4,0x80,0x07,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 7
						0x42,0xb4,0x80,0x06,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 6
						0x42,0xb4,0x80,0x0d,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 13
						0x42,0xb4,0x80,0x07,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 7
						0x42,0xb4,0x80,0x06,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 6
						0x42,0xb4,0x80,0x07,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 7
						0x42,0xb4,0x80,0x06,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 6
						0x42,0xb4,0x80,0x07,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x74, // rest - length 20
						0x42,0xb4,0x80,0x06,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 6
						0x67, // rest - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x6d, // rest - length 13
						0x74, // rest - length 20
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x67, // rest - length 7
						0x42,0xe2,0x80,0x06,0xf4,0x11, // tone freq 495,0Hz - vol 7 swept up - length 6
						0x42,0xe2,0x80,0x07,0xf4,0x11, // tone freq 495,0Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xe2,0x80,0x07,0xf4,0x11, // tone freq 495,0Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0xe2,0x80,0x07,0xf4,0x11, // tone freq 495,0Hz - vol 7 swept up - length 7
						0x42,0xe2,0x80,0x06,0xf4,0x11, // tone freq 495,0Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xd6,0x80,0x06,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 6
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x66, // rest - length 6
						0x42,0xd6,0x80,0x0d,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 13
						0x42,0xd6,0x80,0x07,0xf4,0x11, // tone freq 522,7Hz - vol 7 swept up - length 7
						0x42,0xbe,0x80,0x06,0xf4,0x11, // tone freq 588,7Hz - vol 7 swept up - length 6
						0x42,0xb4,0x80,0x07,0xf4,0x11, // tone freq 621,4Hz - vol 7 swept up - length 7
						0x42,0xaa,0x80,0x06,0xf4,0x11, // tone freq 658,0Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x80,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 6
						0x7a, // rest - length 26
						0x42,0x1d,0x81,0x07,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x80,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 6
						0x42,0x1d,0x81,0x07,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x80,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0x40,0x80,0x07,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 7
						0x42,0x1d,0x81,0x06,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 6
						0x42,0x40,0x80,0x07,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 7
						0x42,0x1d,0x81,0x06,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0x47,0x80,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 7 swept up - length 7
						0x42,0xfd,0x80,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 7 swept up - length 6
						0x42,0x1d,0x81,0x07,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x80,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 7 swept up - length 6
						0x42,0x1d,0x81,0x07,0xf4,0x11, // tone freq 392,5Hz - vol 7 swept up - length 7
						0x42,0x40,0x90,0x06,0xf4,0x11, // tone freq 1747,8Hz - vol 6 swept up - length 6
						0x42,0x47,0x90,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 6 swept up - length 7
						0x42,0xfd,0x90,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 6 swept up - length 6
						0x42,0x47,0xa0,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 5 swept up - length 7
						0x42,0xfd,0xa0,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 5 swept up - length 6
						0x42,0x40,0xb0,0x07,0xf4,0x11, // tone freq 1747,8Hz - vol 4 swept up - length 7
						0x42,0x1d,0xb1,0x06,0xf4,0x11, // tone freq 392,5Hz - vol 4 swept up - length 6
						0x42,0x40,0xc0,0x07,0xf4,0x11, // tone freq 1747,8Hz - vol 3 swept up - length 7
						0x42,0x1d,0xc1,0x06,0xf4,0x11, // tone freq 392,5Hz - vol 3 swept up - length 6
						0x42,0x47,0xd0,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 2 swept up - length 7
						0x42,0xfd,0xd0,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 2 swept up - length 6
						0x42,0x47,0xe0,0x07,0xf4,0x11, // tone freq 1575,5Hz - vol 1 swept up - length 7
						0x42,0xfd,0xe0,0x06,0xf4,0x11, // tone freq 442,1Hz - vol 1 swept up - length 6
						0x40,0x00,0xf0,0xd0, // rest - length 208
						0x58]; // repeat
						
					sndtable[1] = [
						0x80,0x00,0xf0,0xd0, // rest - length 208
						0x82,0x53,0xf1,0x5b,0xfd,0x71, // tone freq 330,0Hz - vol 0 (off) swept up - length 91
						0xa7, // rest - length 7
						0x82,0x94,0x21,0x6e,0x1d,0x86, // tone freq 276,9Hz - vol 13 swept down - length 110
						0x82,0x53,0xf1,0x68,0xfd,0x81, // tone freq 330,0Hz - vol 0 (off) swept up - length 104
						0x82,0xab,0x20,0x0d,0x16,0x17, // tone freq 654,2Hz - vol 13 swept down - length 13
						0x80,0x1d,0x21,0x1a, // tone freq 392,5Hz - vol 13 - length 26
						0x83,0x1d,0x31,0x0b,0x65,0x14,0x1c,0x55, // tone freq 392,5Hz swept down - vol 12 swept down - length 65
						0xae, // rest - length 14
						0x82,0xa7,0x72,0x0d,0x16,0x17, // tone freq 164,7Hz - vol 8 swept down - length 13
						0x82,0x3b,0x72,0x0d,0x16,0x17, // tone freq 195,9Hz - vol 8 swept down - length 13
						0x82,0xfc,0x71,0x0c,0x16,0x16, // tone freq 220,2Hz - vol 8 swept down - length 12
						0x82,0x1d,0x21,0x27,0x16,0x63, // tone freq 392,5Hz - vol 13 swept down - length 39
						0xad, // rest - length 13
						0x82,0x1d,0x21,0x27,0x16,0x63, // tone freq 392,5Hz - vol 13 swept down - length 39
						0xad, // rest - length 13
						0x82,0x94,0x21,0x27,0x16,0x63, // tone freq 276,9Hz - vol 13 swept down - length 39
						0xad, // rest - length 13
						0x82,0x1b,0x22,0x0d,0x16,0x17, // tone freq 207,5Hz - vol 13 swept down - length 13
						0x82, 0xfc, 0x21, 0x5b, 0x1d, 0x6d, // tone freq 220,2Hz - vol 13 swept down - length 91
						///
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xff,0xd0, // rest - length 255
						0x80,0x00,0xf0,0xd0, // rest - length 240
						0x98]; // repeat
						
					sndtable[2] = [
						0xc2,0xf8,0x33,0x0d,0x1c,0x11, // tone freq 110,1Hz - vol 12 swept down - length 13
						0xc2,0xf8,0x33,0x0d,0x1c,0x11, // tone freq 110,1Hz - vol 12 swept down - length 13
						0xc2,0x89,0x33,0x0d,0x1c,0x11, // tone freq 123,6Hz - vol 12 swept down - length 13
						0xc2,0xf8,0x33,0x0d,0x1c,0x11, // tone freq 110,1Hz - vol 12 swept down - length 13
						0xc1,0x57,0x53,0x02,0x67,0xd0, // tone freq 130,8Hz swept up - vol 10 - length 13
						0xc2,0xf8,0x33,0x0d,0x1c,0x11, // tone freq 110,1Hz - vol 12 swept down - length 13
						0xc2,0xfa,0x32,0x0d,0x1c,0x11, // tone freq 146,8Hz - vol 12 swept down - length 13
						0xc2,0x27,0x33,0x0d,0x1c,0x11, // tone freq 138,6Hz - vol 12 swept down - length 13
						0xd8]; // repeat
					
					nbrtables = 3;
					break;
				case 17:
				default:
					nbrtables = 0;
					break;
			}
			
			
		}
		
	}
	
}